package plus.ibatis.hbatis.plugins.dataPermisson.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * data scope column
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
@Target({ ElementType.METHOD })
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface DataColumn {
	
	/**
	 * 别名（尽量指定，不指定则在每个条件后追加）
	 * @return alias
	 */
	String alias() default "";
	
	/**
	 * 列名(查询sql内)
	 * @return column name
	 */
	String column();
	
	/**
	 * 权限key
	 * @return key
	 */
	String key();
	
	/**
	 * 数据类型(String,Number)
	 * @return datatype
	 */
	Class<?> dataType() default String.class;
}
