package plus.ibatis.hbatis.plugins.pagination;

import java.util.List;
import java.util.function.Supplier;

import com.github.pagehelper.ISelect;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;

class PageExecutor {

//	@SuppressWarnings("rawtypes")
//	private static ThreadLocal<Pager> pageParamsHolder = new ThreadLocal<>();
//	
//	public static Pager<?> getPager() {
//		return pageParamsHolder.get(); 
//	}
	public static <T> Pager<T> doPagination(Pager<T> pager,Supplier<List<T>> pageLoadSupplier){
		return doPagination(pager,pageLoadSupplier,true);
	}
	public static <T> Pager<T> doPagination(Pager<T> pager,Supplier<List<T>> pageLoadSupplier,boolean doCountFlag){
		try {
			Page<T> p = PageHelper.offsetPage(pager.getParams().getStart(), pager.getParams().getLimit(),doCountFlag);
			p = p.doSelectPage(new ISelect() {

				@Override
				public void doSelect() {
					pageLoadSupplier.get();
				}
				
			});
			pager.setData(p.getResult());
			pager.setTotal(p.getTotal());
			return pager;
		} finally {
			PageHelper.clearPage();
		}
	}

	public static <T> long doCount(Pager<T> pager, Supplier<List<T>> pageLoadSupplier) {
		try {
			return PageHelper.count(new ISelect() {

				@Override
				public void doSelect() {
					pageLoadSupplier.get();
				}
			});
		} finally {
			PageHelper.clearPage();
		}
	}
}
