package plus.ibatis.hbatis.plugins.pagination;

import java.lang.reflect.InvocationTargetException;
import java.util.Properties;

import org.apache.ibatis.mapping.SqlCommandType;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInterceptor;

import plus.ibatis.hbatis.plugins.Dialect;
import plus.ibatis.hbatis.plugins.InnerInterceptor;
import plus.ibatis.hbatis.plugins.InnerInterceptorContext;

public class PageInnerInterceptor implements InnerInterceptor {
	private PageInterceptor pageInterceptor = null;

	public PageInnerInterceptor() {
		this(Dialect.mysql);
	}
	public PageInnerInterceptor(Dialect dialect) {
		Properties props = new Properties();
		props.setProperty("helperDialect", dialect.name());
		props.setProperty("pageSizeZero","0");//页码长度为0时不分页
		pageInterceptor = new PageInterceptor();
		pageInterceptor.setProperties(props);
	}
	public PageInnerInterceptor(Properties props) {
		pageInterceptor = new PageInterceptor();
		pageInterceptor.setProperties(props);
	}
	public boolean accept(SqlCommandType cmdType) {
		return SqlCommandType.SELECT.equals(cmdType) && PageHelper.getLocalPage() != null;
	}

	@Override
	public void beforeQuery(InnerInterceptorContext ctx) throws InvocationTargetException, IllegalAccessException {
		if (!accept(ctx.getSqlCommandType())) { // 非分页请求
			return ;
		}
		try {
			Object ret = pageInterceptor.intercept(ctx.getInvocation());
			ctx.setInvokedResult(ret);
		} catch (InvocationTargetException | IllegalAccessException ex) {
			throw ex;
		} catch (Throwable e) {
			throw new RuntimeException(e);
		}

	}
}
