package plus.ibatis.hbatis.plugins.pagination;

import java.util.List;
import java.util.function.Supplier;

public class Pager<T> {
	
	private long total;

	private List<T> data;

	private PagerParams params;
	
	public Pager(PagerParams pageParams) {
		this.params = pageParams;
	}

	public Pager(int start, int limit) {
		this.params = new DefaultPageParams(start,limit);
	}
	public void setStart(int start) {
		this.params =  new DefaultPageParams(start,this.params.getLimit());
	}
	public long getTotal() {
		return total;
	}

	public void setTotal(long total) {
		this.total = total;
	}

	public List<T> getData() {
		return data;
	}

	public void setData(List<T> data) {
		this.data = data;
	}

	public PagerParams getParams() {
		return params;
	}

	/**
	 * fetch data function
	 * @param pageLoadSupplier
	 * 			page data load supplier
	 * @return Pager
	 */
	public Pager<T> data(Supplier<List<T>> pageLoadSupplier) {
		return PageExecutor.doPagination(this, pageLoadSupplier);
	}
	
	/**
	 * fetch data function
	 * @param pageLoadSupplier
	 * 			page data load supplier
	 * @param countFlag
	 * 			count flag
	 * @return Pager
	 */
	public Pager<T> data(Supplier<List<T>> pageLoadSupplier,boolean countFlag) {
		return PageExecutor.doPagination(this, pageLoadSupplier,countFlag);
	}
	public long count(Supplier<List<T>> pageLoadSupplier) {
		return PageExecutor.doCount(this, pageLoadSupplier);
	}
	public static interface PagerParams {

		default int getStart() {
			return 0;
		}
		default int getLimit() {
			return 10;
		}
	}

	static class DefaultPageParams implements PagerParams{
		private int start;
		private int limit;
		public DefaultPageParams(int start,int limit) {
			this.start = start;
			this.limit = limit;
		}
		public int getStart() {
			return start;
		}
		public void setStart(int start) {
			this.start = start;
		}
		public int getLimit() {
			return limit;
		}
		public void setLimit(int limit) {
			this.limit = limit;
		}
		
	}
}
