/*
 * Decompiled with CFR 0.152.
 */
package plus.ibatis.hbatis.core;

import java.util.ArrayList;
import java.util.List;
import plus.ibatis.hbatis.core.AbstractFieldNode;
import plus.ibatis.hbatis.core.EntityNode;
import plus.ibatis.hbatis.core.FieldNode;
import plus.ibatis.hbatis.core.meta.EntityMeta;
import plus.ibatis.hbatis.core.metaDescriber.EntityClassDescriber;
import plus.ibatis.hbatis.core.metaDescriber.EntityFieldDescriber;
import plus.ibatis.hbatis.core.util.EntityClassDescriberHelper;

public abstract class AbstractEntityNode<E>
implements EntityNode<E> {
    private String alias;
    private List<FieldNode<E, ?>> fieldPaths = new ArrayList();
    private EntityClassDescriber<E> describer = null;

    public AbstractEntityNode(Class<E> entityClass, String alias) {
        this.alias = alias;
        this.describer = EntityClassDescriberHelper.getEntityClassDescriber(entityClass);
    }

    public static <E> AbstractEntityNode<E> of(Class<E> entityClass) {
        AbstractEntityNode n = new AbstractEntityNode((Class)entityClass, null){};
        List<EntityFieldDescriber> fields = n.describer.getFieldDescribers();
        for (EntityFieldDescriber f : fields) {
            n.ref(f.getFieldName());
        }
        return n;
    }

    protected <K> FieldNode<E, K> ref(String propName) {
        return this.createFieldNode(propName);
    }

    protected <K> FieldNode<E, K> createFieldNode(String propName) {
        try {
            AbstractFieldNode fp = new AbstractFieldNode<E, K>(this, propName){};
            long count = this.fieldPaths.stream().filter(tmp -> tmp.getPropertyName().equals(propName)).count();
            if (count < 1L) {
                this.fieldPaths.add(fp);
            }
            return fp;
        }
        catch (Exception e) {
            throw new RuntimeException("Create FieldNode error[prop:" + propName + "]", e);
        }
    }

    @Override
    public FieldNode<E, ?> getFieldNode(String propName) {
        FieldNode fn = this.fieldPaths.stream().filter(tmp -> tmp.getPropertyName().equals(propName)).findFirst().orElse(null);
        if (fn == null) {
            throw new IllegalArgumentException("Property [" + propName + "] not found");
        }
        return fn;
    }

    @Override
    public EntityMeta<E> getEntityMeta() {
        return this.describer.getEntityMeta();
    }

    @Override
    public String getSqlTable() {
        String name = this.getEntityMeta().getTableName().replaceAll("`", "");
        name = "`" + name + "`";
        if (this.getAlias() != null) {
            name = String.valueOf(name) + " " + this.getAlias();
        }
        return name;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public List<FieldNode<E, ?>> getFieldNodes() {
        return this.fieldPaths;
    }

    @Override
    public String getSqlColumns() {
        StringBuilder sb = new StringBuilder();
        for (FieldNode<E, ?> fm : this.fieldPaths) {
            sb.append("`").append(fm.getFieldMeta().getColumnName()).append("`,");
        }
        return sb.length() > 0 ? sb.deleteCharAt(sb.length() - 1).toString() : "";
    }
}

