/*
 * Decompiled with CFR 0.152.
 */
package plus.ibatis.hbatis.core;

import java.util.List;
import plus.ibatis.hbatis.core.Criterion;
import plus.ibatis.hbatis.core.CriterionOpts;
import plus.ibatis.hbatis.core.EntityNode;
import plus.ibatis.hbatis.core.FieldNode;
import plus.ibatis.hbatis.core.meta.FieldMeta;
import plus.ibatis.hbatis.core.metaDescriber.EntityFieldDescriber;
import plus.ibatis.hbatis.core.util.EntityClassDescriberHelper;

public abstract class AbstractFieldNode<E, T>
implements FieldNode<E, T> {
    private EntityNode<E> entityPath;
    private EntityFieldDescriber fieldDescriber;

    public AbstractFieldNode(EntityNode<E> entityPath, String propName) {
        this.entityPath = entityPath;
        Class entityClass = this.entityPath.getEntityMeta().getEntityClass();
        List<EntityFieldDescriber> fieldDescribers = EntityClassDescriberHelper.getEntityClassDescriber(entityClass).getFieldDescribers();
        this.fieldDescriber = fieldDescribers.stream().filter(r -> r.getFieldMeta().getPropertyName().equals(propName)).findFirst().orElseThrow(() -> new RuntimeException("No property " + propName + " in " + entityClass));
    }

    public static <E, T> AbstractFieldNode of(EntityNode<E> entityPath, String propName) {
        return new AbstractFieldNode((EntityNode)entityPath, propName){};
    }

    @Override
    public String getPropertyName() {
        return this.fieldDescriber.getFieldName();
    }

    @Override
    public String getSqlColumn() {
        String name = this.fieldDescriber.getFieldMeta().getColumnName().replaceAll("`", "");
        if (this.entityPath.getAlias() != null) {
            name = this.entityPath.getAlias() + ".`" + name + "`";
        }
        return name;
    }

    @Override
    public FieldMeta<E, T> getFieldMeta() {
        return this.fieldDescriber.getFieldMeta();
    }

    @Override
    public EntityNode<E> getEntityPath() {
        return this.entityPath;
    }

    @Override
    public Criterion<E, T> eq(T value) {
        return new Criterion(this, CriterionOpts.EQ, value);
    }

    @Override
    public Criterion<E, T> ne(T value) {
        return new Criterion(this, CriterionOpts.NE, value);
    }

    @Override
    public Criterion<E, T> gt(T value) {
        return new Criterion(this, CriterionOpts.GT, value);
    }

    @Override
    public Criterion<E, T> ge(T value) {
        return new Criterion(this, CriterionOpts.GE, value);
    }

    @Override
    public Criterion<E, T> lt(T value) {
        return new Criterion(this, CriterionOpts.LT, value);
    }

    @Override
    public Criterion<E, T> le(T value) {
        return new Criterion(this, CriterionOpts.LE, value);
    }

    @Override
    public Criterion<E, T> isNull() {
        Object t = null;
        return new Criterion(this, CriterionOpts.IS, t);
    }

    @Override
    public Criterion<E, T> isNotNull() {
        Object t = null;
        return new Criterion(this, CriterionOpts.NIS, t);
    }

    @Override
    public Criterion<E, T> between(T value0, T value1) {
        return new Criterion(this, CriterionOpts.BETWEEN, value0, value1);
    }

    @Override
    public Criterion<E, T> notBetween(T value0, T value1) {
        return new Criterion(this, CriterionOpts.NBETWEEN, value0, value1);
    }

    @Override
    public Criterion<E, T> in(List<T> list) {
        return new Criterion(this, CriterionOpts.IN, list);
    }

    @Override
    public Criterion<E, T> notIn(List<T> list) {
        return new Criterion(this, CriterionOpts.NIN, list);
    }

    @Override
    public Criterion<E, T> like(T value) {
        return new Criterion(this, CriterionOpts.LIKE, value);
    }

    @Override
    public Criterion<E, T> notLike(T value) {
        return new Criterion(this, CriterionOpts.NLIKE, value);
    }

    @Override
    public Criterion<E, T> gt(FieldNode<E, T> a) {
        return new Criterion<E, T>(this, CriterionOpts.GT, a);
    }

    @Override
    public Criterion<E, T> eq(FieldNode<E, T> a) {
        return new Criterion<E, T>(this, CriterionOpts.EQ, a);
    }

    @Override
    public Criterion<E, T> ne(FieldNode<E, T> a) {
        return new Criterion<E, T>(this, CriterionOpts.NE, a);
    }

    @Override
    public Criterion<E, T> lt(FieldNode<E, T> a) {
        return new Criterion<E, T>(this, CriterionOpts.LT, a);
    }

    @Override
    public Criterion<E, T> le(FieldNode<E, T> a) {
        return new Criterion<E, T>(this, CriterionOpts.LE, a);
    }

    @Override
    public Criterion<E, T> ge(FieldNode<E, T> a) {
        return new Criterion<E, T>(this, CriterionOpts.GE, a);
    }

    @Override
    public Criterion<E, T> regexp(T value) {
        return new Criterion(this, CriterionOpts.REGEXP, value);
    }

    @Override
    public Criterion<E, T> sql(CriterionOpts opt, String sql) {
        if (CriterionOpts.BETWEEN.equals((Object)opt) || CriterionOpts.NBETWEEN.equals((Object)opt)) {
            throw new IllegalArgumentException("Not support between operation by sql.");
        }
        Criterion c = new Criterion(this, opt);
        c.setSqlValue(sql);
        return c;
    }
}

