/*
 * Decompiled with CFR 0.152.
 */
package plus.ibatis.hbatis.core.meta;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import plus.ibatis.hbatis.core.IdStrategy;
import plus.ibatis.hbatis.core.meta.EntityMeta;
import plus.ibatis.hbatis.core.type.JdbcType;

public class FieldMeta<E, T> {
    private EntityMeta<E> entityMeta;
    private Class<T> fieldType;
    private String columnName;
    private String propertyName;
    private JdbcType jdbcType;
    private boolean primaryKey;
    private boolean insertable = true;
    private boolean updatable = true;
    private boolean nullable = true;
    private boolean indexed = false;
    private int length;
    private String comment;
    private IdStrategy idStrategy;
    private Class idStrategyClass;
    private static Set<Class<?>> normalTypes = new HashSet();

    public FieldMeta(EntityMeta<E> entityMeta, Class<T> clazz, String propName, String columnName) {
        this.entityMeta = entityMeta;
        this.fieldType = clazz;
        this.columnName = columnName;
        this.propertyName = propName;
    }

    public EntityMeta<?> getEntityMeta() {
        return this.entityMeta;
    }

    public Class<T> getFieldType() {
        return this.fieldType;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public JdbcType getJdbcType() {
        return this.jdbcType;
    }

    public void setJdbcType(JdbcType jdbcType) {
        this.jdbcType = jdbcType;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public boolean isInsertable() {
        return this.insertable;
    }

    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    public IdStrategy getIdStrategy() {
        return this.idStrategy;
    }

    public void setIdStrategy(IdStrategy idStrategy) {
        this.idStrategy = idStrategy;
    }

    public boolean isAutoIncrement() {
        return IdStrategy.IDENTITY.equals((Object)this.idStrategy);
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public void setIndexed(boolean indexed) {
        this.indexed = indexed;
    }

    public Class getIdStrategyClass() {
        return this.idStrategyClass;
    }

    public void setIdStrategyClass(Class idStrategyClass) {
        this.idStrategyClass = idStrategyClass;
    }

    public boolean isNormalType() {
        for (Class<T> clazz : normalTypes) {
            if (!clazz.isAssignableFrom(this.fieldType)) continue;
            return true;
        }
        return false;
    }

    static {
        normalTypes.add(String.class);
        normalTypes.add(Number.class);
        normalTypes.add(Integer.TYPE);
        normalTypes.add(Long.TYPE);
        normalTypes.add(Double.TYPE);
        normalTypes.add(Float.TYPE);
        normalTypes.add(Boolean.class);
        normalTypes.add(Boolean.TYPE);
        normalTypes.add(Byte.class);
        normalTypes.add(Date.class);
        normalTypes.add(Character.class);
        normalTypes.add(Character.TYPE);
    }
}

