/*
 * Decompiled with CFR 0.152.
 */
package plus.ibatis.hbatis.core.metaDescriber;

import java.util.List;
import java.util.stream.Collectors;
import plus.ibatis.hbatis.core.meta.EntityMeta;
import plus.ibatis.hbatis.core.metaDescriber.EntityFieldDescriber;

public class EntityClassDescriber<T> {
    private List<EntityFieldDescriber> fieldDescribers;
    private EntityMeta<T> entityMeta;
    private Class<T> entityClass;

    public EntityClassDescriber(Class<T> entityClass) {
        this.entityClass = entityClass;
    }

    public EntityMeta<T> getEntityMeta() {
        return this.entityMeta;
    }

    public void setEntityMeta(EntityMeta<T> entityMeta) {
        this.entityMeta = entityMeta;
    }

    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    public List<EntityFieldDescriber> getFieldDescribers() {
        return this.fieldDescribers;
    }

    public void setFieldDescribers(List<EntityFieldDescriber> fieldDescribers) {
        this.fieldDescribers = fieldDescribers;
    }

    public String getTableColumns() {
        if (this.fieldDescribers == null || this.fieldDescribers.isEmpty()) {
            throw new RuntimeException("None Define FieldMeta");
        }
        StringBuilder sb = new StringBuilder();
        for (EntityFieldDescriber fm : this.getFieldDescribers()) {
            sb.append("`").append(fm.getFieldMeta().getColumnName()).append("`,");
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    public String getTableBaseColumns() {
        if (this.fieldDescribers == null || this.fieldDescribers.isEmpty()) {
            throw new RuntimeException("None Define FieldMeta[entity:" + this.entityClass + "]");
        }
        StringBuilder sb = new StringBuilder();
        for (EntityFieldDescriber fm : this.getFieldDescribers()) {
            if (!fm.getFieldMeta().isNormalType()) continue;
            sb.append("`").append(fm.getFieldMeta().getColumnName()).append("`,");
        }
        return sb.length() > 0 ? sb.deleteCharAt(sb.length() - 1).toString() : "";
    }

    public List<EntityFieldDescriber> getPrimaryKeys() {
        return this.fieldDescribers.stream().filter(f -> f.getFieldMeta().isPrimaryKey()).collect(Collectors.toList());
    }
}

