/*
 * Decompiled with CFR 0.152.
 */
package plus.ibatis.hbatis.core.metaDescriber.adapter;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import plus.ibatis.hbatis.core.IdStrategy;
import plus.ibatis.hbatis.core.annotation.Indexed;
import plus.ibatis.hbatis.core.meta.EntityMeta;
import plus.ibatis.hbatis.core.meta.FieldMeta;
import plus.ibatis.hbatis.core.metaDescriber.EntityClassDescriber;
import plus.ibatis.hbatis.core.metaDescriber.EntityFieldDescriber;
import plus.ibatis.hbatis.core.metaDescriber.IEntityClassReader;
import plus.ibatis.hbatis.core.type.JdbcType;
import plus.ibatis.hbatis.core.util.DefaultJdbcTypeRegistry;

public class JpaAnnotationReader
implements IEntityClassReader {
    @Override
    public <E> EntityClassDescriber<E> read(Class<E> entityClass) {
        EntityClassDescriber<E> d = new EntityClassDescriber<E>(entityClass);
        Table table = entityClass.getAnnotation(Table.class);
        if (table == null) {
            throw new IllegalArgumentException("Class do's not have table annotation.class:" + entityClass);
        }
        EntityMeta<E> m = new EntityMeta<E>(entityClass, table.name());
        d.setEntityMeta(m);
        List<EntityFieldDescriber> fieldDescribers = this.getFieldDescribers(m, entityClass);
        d.setFieldDescribers(fieldDescribers);
        return d;
    }

    private List<EntityFieldDescriber> getFieldDescribers(EntityMeta<?> entityMeta, Class<?> entityClass) {
        Field[] fields;
        ArrayList<EntityFieldDescriber> result = new ArrayList<EntityFieldDescriber>();
        for (Field f2 : fields = entityClass.getDeclaredFields()) {
            EntityFieldDescriber fd = this.readField(entityMeta, f2);
            if (fd == null) continue;
            result.add(fd);
        }
        if (!entityClass.getSuperclass().equals(Object.class)) {
            List<EntityFieldDescriber> superFields = this.getFieldDescribers(entityMeta, entityClass.getSuperclass());
            List filtedFields = superFields.stream().filter(f -> !this.isExists((List<EntityFieldDescriber>)result, (EntityFieldDescriber)f)).collect(Collectors.toList());
            result.addAll(filtedFields);
        }
        return result;
    }

    private boolean isExists(List<EntityFieldDescriber> rs, EntityFieldDescriber d) {
        return rs.stream().filter(r -> r.getFieldMeta().getPropertyName().equals(d.getFieldMeta().getPropertyName())).findAny().isPresent();
    }

    private EntityFieldDescriber readField(EntityMeta<?> entityMeta, Field f) {
        Column col = f.getAnnotation(Column.class);
        Id id = f.getAnnotation(Id.class);
        if (col == null && id == null) {
            return null;
        }
        EntityFieldDescriber fd = new EntityFieldDescriber();
        fd.setField(f);
        Class<?> fieldType = f.getType();
        JdbcType jdbcType = DefaultJdbcTypeRegistry.getDefaultJdbcType(fieldType);
        String colName = col == null ? f.getName() : col.name();
        FieldMeta fieldMeta = new FieldMeta(entityMeta, f.getType(), f.getName(), colName);
        fieldMeta.setJdbcType(jdbcType);
        if (id != null) {
            fieldMeta.setPrimaryKey(true);
            GeneratedValue genValue = f.getAnnotation(GeneratedValue.class);
            if (genValue != null) {
                if (GenerationType.IDENTITY.equals((Object)genValue.strategy())) {
                    fieldMeta.setIdStrategy(IdStrategy.IDENTITY);
                }
                if (GenerationType.AUTO.equals((Object)genValue.strategy())) {
                    fieldMeta.setIdStrategy(IdStrategy.AUTO);
                }
                if (GenerationType.SEQUENCE.equals((Object)genValue.strategy())) {
                    fieldMeta.setIdStrategy(IdStrategy.UUID);
                }
            }
        } else {
            fieldMeta.setPrimaryKey(false);
        }
        if (col != null) {
            fieldMeta.setUpdatable(col.updatable());
            fieldMeta.setInsertable(col.insertable());
            fieldMeta.setLength(col.length());
            fieldMeta.setNullable(col.nullable());
            fieldMeta.setComment("");
        } else {
            fieldMeta.setUpdatable(false);
            fieldMeta.setInsertable(true);
            fieldMeta.setNullable(false);
            fieldMeta.setComment("Key");
        }
        boolean isIndexed = fieldMeta.isPrimaryKey();
        if (!isIndexed) {
            Indexed indexed = f.getAnnotation(Indexed.class);
            isIndexed = indexed != null;
        }
        fieldMeta.setIndexed(isIndexed);
        fd.setFieldName(f.getName());
        fd.setFieldMeta(fieldMeta);
        return fd;
    }

    @Override
    public <E> boolean canRead(Class<E> entityClass) {
        return entityClass.isAnnotationPresent(Table.class);
    }
}

