/*
 * Decompiled with CFR 0.152.
 */
package plus.ibatis.hbatis.core.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.apache.ibatis.io.Resources;
import org.springframework.util.Assert;

public final class ClassUtils {
    private static ClassLoader systemClassLoader;
    private static final List<String> PROXY_CLASS_NAMES;

    private ClassUtils() {
    }

    public static boolean isBoolean(Class<?> type) {
        return type == Boolean.TYPE || Boolean.class == type;
    }

    public static boolean isProxy(Class<?> clazz) {
        if (clazz != null) {
            for (Class<?> cls : clazz.getInterfaces()) {
                if (!PROXY_CLASS_NAMES.contains(cls.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static Class<?> getUserClass(Class<?> clazz) {
        Assert.notNull(clazz, (String)"Class must not be null");
        return ClassUtils.isProxy(clazz) ? clazz.getSuperclass() : clazz;
    }

    public static Class<?> getUserClass(Object object) {
        Assert.notNull((Object)object, (String)"Instance must not be null");
        return ClassUtils.getUserClass(object.getClass());
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T newInstance(String clazzName) {
        return (T)ClassUtils.newInstance(ClassUtils.toClassConfident(clazzName));
    }

    public static Class<?> toClassConfident(String name) {
        return ClassUtils.toClassConfident(name, null);
    }

    public static Class<?> toClassConfident(String name, ClassLoader classLoader) {
        try {
            return ClassUtils.loadClass(name, ClassUtils.getClassLoaders(classLoader));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<?> loadClass(String className, ClassLoader[] classLoaders) throws ClassNotFoundException {
        for (ClassLoader classLoader : classLoaders) {
            if (classLoader == null) continue;
            try {
                return Class.forName(className, true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException("Cannot find class: " + className);
    }

    public static String getPackageName(Class<?> clazz) {
        Assert.notNull(clazz, (String)"Class must not be null");
        return ClassUtils.getPackageName(clazz.getName());
    }

    public static String getPackageName(String fqClassName) {
        Assert.notNull((Object)fqClassName, (String)"Class name must not be null");
        int lastDotIndex = fqClassName.lastIndexOf(".");
        return lastDotIndex != -1 ? fqClassName.substring(0, lastDotIndex) : "";
    }

    @Deprecated
    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = ClassUtils.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }

    private static ClassLoader[] getClassLoaders(ClassLoader classLoader) {
        return new ClassLoader[]{classLoader, Resources.getDefaultClassLoader(), Thread.currentThread().getContextClassLoader(), ClassUtils.class.getClassLoader(), systemClassLoader};
    }

    static {
        try {
            systemClassLoader = ClassLoader.getSystemClassLoader();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        PROXY_CLASS_NAMES = Arrays.asList("net.sf.cglib.proxy.Factory", "org.springframework.cglib.proxy.Factory", "javassist.util.proxy.ProxyObject", "org.apache.ibatis.javassist.util.proxy.ProxyObject");
    }
}

