/*
 * Decompiled with CFR 0.152.
 */
package plus.ibatis.hbatis.core.util;

import java.math.BigDecimal;
import java.sql.Blob;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import plus.ibatis.hbatis.core.type.JdbcType;

public final class DefaultJdbcTypeRegistry {
    private static final Map<Class<?>, JdbcType> jdbcTypeMap = new HashMap<Class<?>, JdbcType>(){
        private static final long serialVersionUID = -5302727745166102178L;
        {
            this.put(Integer.class, JdbcType.INTEGER);
            this.put(Integer.TYPE, JdbcType.INTEGER);
            this.put(Long.class, JdbcType.BIGINT);
            this.put(Long.TYPE, JdbcType.BIGINT);
            this.put(Short.class, JdbcType.SMALLINT);
            this.put(Short.TYPE, JdbcType.SMALLINT);
            this.put(Float.class, JdbcType.FLOAT);
            this.put(Float.TYPE, JdbcType.FLOAT);
            this.put(Double.class, JdbcType.DOUBLE);
            this.put(Double.TYPE, JdbcType.DOUBLE);
            this.put(BigDecimal.class, JdbcType.DECIMAL);
            this.put(String.class, JdbcType.VARCHAR);
            this.put(Byte.class, JdbcType.TINYINT);
            this.put(Boolean.class, JdbcType.BOOLEAN);
            this.put(Boolean.TYPE, JdbcType.BOOLEAN);
            this.put(Date.class, JdbcType.TIMESTAMP);
            this.put(Blob.class, JdbcType.BLOB);
        }
    };

    public static JdbcType getDefaultJdbcType(Class<?> clazz) {
        return jdbcTypeMap.get(clazz);
    }
}

