/*
 * Decompiled with CFR 0.152.
 */
package plus.ibatis.hbatis.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import plus.ibatis.hbatis.core.metaDescriber.EntityClassDescriber;
import plus.ibatis.hbatis.core.metaDescriber.IEntityClassReader;
import plus.ibatis.hbatis.core.metaDescriber.adapter.DefaultAnnotationReader;
import plus.ibatis.hbatis.core.metaDescriber.adapter.JpaAnnotationReader;

public class EntityClassDescriberHelper {
    private static Map<Class<?>, EntityClassDescriber<?>> holder = new ConcurrentHashMap();
    private static List<IEntityClassReader> readers = new ArrayList<IEntityClassReader>();

    private EntityClassDescriberHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E> EntityClassDescriber<E> getEntityClassDescriber(Class<E> entityClass) {
        EntityClassDescriber<Object> d = holder.get(entityClass);
        if (d == null) {
            List<IEntityClassReader> list = readers;
            synchronized (list) {
                for (IEntityClassReader reader : readers) {
                    boolean flag = reader.canRead(entityClass);
                    if (!flag) continue;
                    d = reader.read(entityClass);
                    break;
                }
                holder.put(entityClass, d);
            }
        }
        return d;
    }

    static {
        readers.add(new DefaultAnnotationReader());
        readers.add(new JpaAnnotationReader());
    }
}

