/*
 * Decompiled with CFR 0.152.
 */
package plus.ibatis.hbatis.orm;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import plus.ibatis.hbatis.orm.HBatisConfiguration;
import plus.ibatis.hbatis.orm.sql.SqlBuilder;

public class HBatisSqlBuilderFactory {
    private static Map<String, HBatisSqlBuilderFactory> instances = new ConcurrentHashMap<String, HBatisSqlBuilderFactory>();
    private String dialect;
    private Map<String, Class<?>> sqlBuilders = new HashMap();

    public static HBatisSqlBuilderFactory getInstance(String dialect) {
        return instances.computeIfAbsent(dialect, key -> new HBatisSqlBuilderFactory(dialect));
    }

    private HBatisSqlBuilderFactory(String dialect) {
        this.dialect = dialect;
    }

    public String getDialect() {
        return this.dialect;
    }

    public <T extends SqlBuilder> void regist(String methodName, Class<T> sqlBuilderClass) {
        this.sqlBuilders.put(methodName, sqlBuilderClass);
    }

    public Class<?> get(String methodName) {
        return this.sqlBuilders.get(methodName);
    }

    public static Class<?> getSqlBuilderClass(String dialect, String methodName) throws ClassNotFoundException {
        Class<?> tmp = HBatisSqlBuilderFactory.getInstance(dialect).get(methodName);
        if (tmp == null) {
            tmp = HBatisConfiguration.getSqlBuilderClass(dialect, methodName);
        }
        return tmp;
    }
}

