/*
 * Decompiled with CFR 0.152.
 */
package plus.ibatis.hbatis.orm;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.binding.MapperRegistry;
import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.session.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plus.ibatis.hbatis.core.metaDescriber.EntityClassDescriber;
import plus.ibatis.hbatis.core.util.EntityClassDescriberHelper;
import plus.ibatis.hbatis.orm.HBatisConfiguration;
import plus.ibatis.hbatis.orm.HBatisSqlBuilderFactory;
import plus.ibatis.hbatis.orm.annotation.EntityResultMapping;
import plus.ibatis.hbatis.orm.sql.KeyGeneratorBuilder;
import plus.ibatis.hbatis.orm.sql.ResultMapsBuilder;
import plus.ibatis.hbatis.orm.sql.SqlBuilder;
import plus.ibatis.hbatis.orm.util.XNodeUtil;

public class HbatisStatementBuilder {
    private static final Logger logger = LoggerFactory.getLogger(HbatisStatementBuilder.class);
    private SqlSourceBuilder sqlSourceBuilder;
    private Set<Method> baseMethodSet = new HashSet<Method>();
    private String dialect = "mysql";
    private Collection<Class<?>> mappers;
    private Configuration configuration;
    private Class<?> baseMapperClass = null;
    static Map<Configuration, HbatisStatementBuilder> factory = new ConcurrentHashMap<Configuration, HbatisStatementBuilder>();
    private KeyGeneratorBuilder keyGeneratorBuilder;

    public static synchronized HbatisStatementBuilder getInstance(Configuration configuration) {
        if (factory.containsKey(configuration)) {
            return factory.get(configuration);
        }
        HbatisStatementBuilder b = new HbatisStatementBuilder(configuration);
        factory.put(configuration, b);
        return b;
    }

    protected HbatisStatementBuilder(Configuration configuration) {
        this(configuration, HBatisConfiguration.getBaseMapper());
    }

    protected HbatisStatementBuilder(Configuration configuration, Class<?> baseMapperClass) {
        this.configuration = configuration;
        this.baseMapperClass = baseMapperClass;
        try {
            Class<?>[] superClas;
            Method[] methods = baseMapperClass.getMethods();
            Collections.addAll(this.baseMethodSet, methods);
            logger.info("BaseMapper({}) statements:{}", baseMapperClass, this.baseMethodSet);
            this.addMapperIfNotExists(baseMapperClass);
            for (Class<?> superCla : superClas = baseMapperClass.getInterfaces()) {
                this.addMapperIfNotExists(superCla);
            }
            this.addMapperIfNotExists(baseMapperClass);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        MapperRegistry r = configuration.getMapperRegistry();
        this.mappers = r.getMappers();
        this.sqlSourceBuilder = new SqlSourceBuilder(configuration);
        try {
            Class<KeyGeneratorBuilder> keyBuilderClass = HBatisConfiguration.getKeyGeneratorBuilder(this.dialect);
            this.keyGeneratorBuilder = keyBuilderClass.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private void addMapperIfNotExists(Class<?> mapperClass) {
        if (!this.configuration.hasMapper(mapperClass)) {
            this.configuration.addMapper(mapperClass);
        }
    }

    public void build() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (this.mappers == null || this.mappers.isEmpty()) {
            return;
        }
        this.initDao();
    }

    private boolean hasProccedMapperClass(Class<?> mapperClass) {
        String resultMapId = mapperClass.getName() + "." + "$BaseResultMap";
        return this.configuration.hasResultMap(resultMapId);
    }

    public void addMapper(Class<?> mapperClass) {
        if (this.hasProccedMapperClass(mapperClass)) {
            logger.debug("Mapper interface has registed." + mapperClass);
            return;
        }
        this.processMapper(mapperClass);
    }

    private void processMapper(Class<?> mapperClass) {
        if (this.baseMapperClass.isAssignableFrom(mapperClass) && !this.baseMapperClass.equals(mapperClass)) {
            logger.info("Preprocessing mapper [BaseResultMap / BaseColumnList]:{}", mapperClass);
            EntityClassDescriber<?> entityDescriber = HbatisStatementBuilder.getEntityClassDescriber(mapperClass);
            this.addResultMaps(mapperClass, entityDescriber);
            this.addBaseColumns(mapperClass, entityDescriber);
            for (Method m : this.baseMethodSet) {
                this.addStatement(mapperClass, m, entityDescriber);
            }
        }
    }

    protected void initDao() {
        for (Class<?> mapperClass : this.mappers) {
            this.processMapper(mapperClass);
        }
    }

    public SqlSourceBuilder getSqlSourceBuilder() {
        return this.sqlSourceBuilder;
    }

    public String getDialect() {
        return this.dialect;
    }

    private static Class<?> getEntityClassByInterface(Class<?> mapperClass) {
        ParameterizedType pt = (ParameterizedType)mapperClass.getGenericInterfaces()[0];
        Class entityClass = (Class)pt.getActualTypeArguments()[0];
        return entityClass;
    }

    private Method getMapperMethod(Class<?> mapperClass, Method baseMethod) {
        for (Method m : mapperClass.getMethods()) {
            if (!m.getName().equals(baseMethod.getName())) continue;
            return m;
        }
        throw new RuntimeException("method not found");
    }

    private String getBaseStatementId(Class<?> baseMapperCla, Method mapperMethod) {
        Class<?>[] superClaList;
        String baseStatementId = baseMapperCla.getName() + "." + mapperMethod.getName();
        if (this.configuration.hasStatement(baseStatementId, false)) {
            return baseStatementId;
        }
        for (Class<?> superCla : superClaList = baseMapperCla.getInterfaces()) {
            String tmp = this.getBaseStatementId(superCla, mapperMethod);
            if (tmp == null) continue;
            return tmp;
        }
        return null;
    }

    private synchronized String addStatement(Class<?> mapperClass, Method m, EntityClassDescriber<?> entityDescriber) {
        Method mapperMethod = this.getMapperMethod(mapperClass, m);
        Class<?> entityClass = entityDescriber.getEntityClass();
        String methodName = mapperMethod.getName();
        String statementId = mapperClass.getName() + "." + methodName;
        logger.debug("statement id:{}", (Object)statementId);
        if (this.configuration.hasStatement(statementId, false)) {
            return statementId;
        }
        String baseStatementId = this.getBaseStatementId(this.baseMapperClass, mapperMethod);
        logger.debug("statement id:{},baseStatementId:{}", (Object)statementId, (Object)baseStatementId);
        MappedStatement mappedSt = null;
        if (baseStatementId != null && this.configuration.hasStatement(baseStatementId, false)) {
            MappedStatement baseStatement = this.configuration.getMappedStatement(baseStatementId, false);
            if (!this.configuration.hasStatement(statementId, false)) {
                mappedSt = this.cloneStatement(mapperClass, mapperMethod, entityClass, baseStatement, statementId, baseStatementId);
            }
        } else {
            SqlBuilder sqlBuilder;
            try {
                sqlBuilder = this.createSqlBuilder(mapperClass, methodName, entityClass);
            }
            catch (Exception e) {
                throw new RuntimeException("build statement error[id:" + statementId + "]", e);
            }
            mappedSt = this.buildNewStatement(mapperClass, mapperMethod, entityClass, statementId, sqlBuilder);
        }
        if (mappedSt != null) {
            this.configuration.addMappedStatement(mappedSt);
        }
        return statementId;
    }

    protected SqlBuilder createSqlBuilder(Class<?> mapperMapper, String methodName, Class<?> entityClass) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException, SecurityException {
        Class<?> sqlSourceClass = HBatisSqlBuilderFactory.getSqlBuilderClass(this.dialect, methodName);
        Constructor<?> constructor = sqlSourceClass.getDeclaredConstructor(SqlSourceBuilder.class, Class.class);
        SqlBuilder sqlBuilder = (SqlBuilder)constructor.newInstance(this.sqlSourceBuilder, entityClass);
        return sqlBuilder;
    }

    private MappedStatement buildNewStatement(Class<?> mapperClass, Method mapperMethod, Class<?> entityClass, String statementId, SqlBuilder sqlBuilder) {
        MappedStatement.Builder statementBuilder = new MappedStatement.Builder(this.configuration, statementId, (SqlSource)sqlBuilder, sqlBuilder.getSqlCommandType());
        if (SqlCommandType.SELECT.equals((Object)sqlBuilder.getSqlCommandType()) && sqlBuilder.getResultType() != null) {
            ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
            ResultMap.Builder resultMapBuilder = new ResultMap.Builder(this.configuration, statementBuilder.id() + "_Inline", sqlBuilder.getResultType(), (List)(sqlBuilder.getResultMappingList() == null ? new ArrayList(0) : sqlBuilder.getResultMappingList()));
            resultMaps.add(resultMapBuilder.build());
            statementBuilder.resultMaps(resultMaps);
        }
        if (SqlCommandType.INSERT.equals((Object)sqlBuilder.getSqlCommandType())) {
            this.keyGeneratorBuilder.build(statementBuilder, entityClass);
        }
        return statementBuilder.build();
    }

    private MappedStatement cloneStatement(Class<?> mapperClass, Method method, Class<?> entityClass, MappedStatement baseStatement, String statementId, String baseStatementId) {
        MappedStatement.Builder statementBuilder = new MappedStatement.Builder(baseStatement.getConfiguration(), statementId, baseStatement.getSqlSource(), baseStatement.getSqlCommandType());
        statementBuilder.resultMaps(baseStatement.getResultMaps());
        this.setResultMap(statementBuilder, mapperClass, method);
        return statementBuilder.build();
    }

    public static EntityClassDescriber<?> getEntityClassDescriber(Class<?> mapperClass) {
        Class<?> entityClass = HbatisStatementBuilder.getEntityClassByInterface(mapperClass);
        EntityClassDescriber<?> d = EntityClassDescriberHelper.getEntityClassDescriber(entityClass);
        return d;
    }

    private void addBaseColumns(Class<?> mapperClass, EntityClassDescriber<?> mapping) {
        String sid = mapperClass.getName() + "." + "$BaseColumnList";
        if (!this.configuration.getSqlFragments().containsKey(sid)) {
            logger.debug("build baseColumns.id:{},baseColumns:{}", (Object)sid, (Object)mapping.getTableBaseColumns());
            XNode baseColumnNode = XNodeUtil.getRootNode("<script>" + mapping.getTableBaseColumns() + "</script>");
            this.configuration.getSqlFragments().put(sid, baseColumnNode);
        }
    }

    private void addResultMaps(Class<?> mapperClass, EntityClassDescriber<?> entityDescriber) {
        String resultMapId = mapperClass.getName() + "." + "$BaseResultMap";
        if (!this.configuration.hasResultMap(resultMapId)) {
            ResultMap rm = ResultMapsBuilder.buildResultMap(resultMapId, this.configuration, entityDescriber);
            this.configuration.addResultMap(rm);
            logger.debug("resultMap[id:{}],mappings:\n{}", (Object)resultMapId, (Object)rm.getResultMappings());
        }
    }

    private void setResultMap(MappedStatement.Builder statementBuilder, Class<?> mapperClass, Method m) {
        if (m.getAnnotation(EntityResultMapping.class) != null) {
            String resultMapId = mapperClass.getName() + "." + "$BaseResultMap";
            statementBuilder.resultMaps(Arrays.asList(this.configuration.getResultMap(resultMapId)));
        }
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }
}

