/*
 * Decompiled with CFR 0.152.
 */
package plus.ibatis.hbatis.orm.criteria;

import java.util.ArrayList;
import java.util.List;
import plus.ibatis.hbatis.core.EntityNode;
import plus.ibatis.hbatis.core.FieldNode;
import plus.ibatis.hbatis.orm.criteria.EntityOpt;

public class Aggregations<E>
extends EntityOpt<E> {
    private List<Aggregation> aggregationList = new ArrayList<Aggregation>();

    private Aggregations(EntityNode<E> n) {
        super(n);
    }

    public static <E> Aggregations<E> newInstance(EntityNode<E> n) {
        return new Aggregations<E>(n);
    }

    public Aggregations<E> count(FieldNode<E, ?> fn) {
        this.aggregation(fn, "count");
        return this;
    }

    public Aggregations<E> count(FieldNode<E, ?> fn, String alias) {
        this.aggregation(fn, "count", alias);
        return this;
    }

    public Aggregations<E> sum(FieldNode<E, ?> fn) {
        this.aggregation(fn, "sum");
        return this;
    }

    public Aggregations<E> sum(FieldNode<E, ?> fn, String alias) {
        this.aggregation(fn, "sum", alias);
        return this;
    }

    public Aggregations<E> min(FieldNode<E, ?> fn) {
        this.aggregation(fn, "min");
        return this;
    }

    public Aggregations<E> min(FieldNode<E, ?> fn, String alias) {
        this.aggregation(fn, "min", alias);
        return this;
    }

    public Aggregations<E> max(FieldNode<E, ?> fn) {
        this.aggregation(fn, "max");
        return this;
    }

    public Aggregations<E> max(FieldNode<E, ?> fn, String alias) {
        this.aggregation(fn, "max", alias);
        return this;
    }

    public Aggregations<E> avg(FieldNode<E, ?> fn) {
        this.aggregation(fn, "avg");
        return this;
    }

    public Aggregations<E> avg(FieldNode<E, ?> fn, String alias) {
        this.aggregation(fn, "avg", alias);
        return this;
    }

    private Aggregations<E> aggregation(FieldNode<E, ?> fn, String op) {
        this.aggregationList.add(new Aggregation(fn, op, fn.getFieldMeta().getPropertyName()));
        return this;
    }

    private Aggregations<E> aggregation(FieldNode<E, ?> fn, String op, String alias) {
        this.aggregationList.add(new Aggregation(fn, op, alias));
        return this;
    }

    public List<Aggregation> getAggregationList() {
        return this.aggregationList;
    }

    public int size() {
        return this.aggregationList.size();
    }

    public String toString() {
        List<Aggregation> list = this.getAggregationList();
        if (list == null || list.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Aggregation o : list) {
            sb.append(",").append(o.getOp()).append("(");
            sb.append(o.getNode().getSqlColumn()).append(")").append(" ").append(o.getAlias());
        }
        return sb.substring(1);
    }

    public static class Aggregation {
        private FieldNode node;
        private String op;
        private String alias;

        public Aggregation(FieldNode node, String op, String alias) {
            this.node = node;
            this.op = op;
            this.alias = alias;
        }

        public FieldNode getNode() {
            return this.node;
        }

        public String getOp() {
            return this.op;
        }

        public String getAlias() {
            return this.alias;
        }
    }
}

