/*
 * Decompiled with CFR 0.152.
 */
package plus.ibatis.hbatis.orm.criteria;

import java.util.ArrayList;
import java.util.List;
import plus.ibatis.hbatis.core.EntityNode;
import plus.ibatis.hbatis.core.FieldNode;
import plus.ibatis.hbatis.core.lambda.SFunction;
import plus.ibatis.hbatis.orm.criteria.EntityOpt;
import plus.ibatis.hbatis.orm.criteria.SortOrder;

public class Orders<E>
extends EntityOpt<E> {
    private List<SortOrder> orderList = new ArrayList<SortOrder>();

    private Orders(EntityNode<E> n) {
        super(n);
    }

    public static <E> Orders<E> newInstance(EntityNode<E> n) {
        return new Orders<E>(n);
    }

    public Orders<E> desc(FieldNode<E, ?> fn) {
        this.order(fn, "desc");
        return this;
    }

    public Orders<E> asc(FieldNode<E, ?> fn) {
        this.order(fn, "asc");
        return this;
    }

    private Orders<E> order(FieldNode<E, ?> fn, String type) {
        this.orderList.add(new SortOrder(fn, type));
        return this;
    }

    public Orders<E> desc(SFunction<? super E, ?> func) {
        String prop = this.prop(func);
        return this.desc(this.field(prop));
    }

    public Orders<E> asc(SFunction<? super E, ?> func) {
        String prop = this.prop(func);
        return this.asc(this.field(prop));
    }

    public Orders<E> desc(String prop) {
        return this.desc(this.field(prop));
    }

    public Orders<E> asc(String prop) {
        return this.asc(this.field(prop));
    }

    public List<SortOrder> getOrderList() {
        return this.orderList;
    }

    public int size() {
        return this.orderList.size();
    }

    public void reset() {
        this.orderList.clear();
    }

    public String toString() {
        List<SortOrder> list = this.getOrderList();
        if (list == null || list.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (SortOrder o : list) {
            sb.append(",");
            sb.append(o.getSortField().getSqlColumn()).append(" ").append(o.getSortType());
        }
        return sb.substring(1);
    }

    public static <E> Orders<E> fromString(EntityNode<E> entityNode, String orderBys) {
        String[] orderByArr;
        if (orderBys == null || orderBys.trim().equals("")) {
            return null;
        }
        Orders<E> sortOrders = new Orders<E>(entityNode);
        block0: for (String orderBy : orderByArr = orderBys.split(",")) {
            String[] tmpArr = orderBy.split("(\\||\\s+)");
            String sortType = tmpArr[1];
            String sortField = tmpArr[0];
            List<FieldNode<E, ?>> nodes = entityNode.getFieldNodes();
            for (FieldNode<E, ?> tmp : nodes) {
                if (!tmp.getFieldMeta().getPropertyName().equals(sortField)) continue;
                super.order(tmp, sortType.equals("desc") ? "desc" : "asc");
                continue block0;
            }
        }
        return sortOrders;
    }
}

