/*
 * Decompiled with CFR 0.152.
 */
package plus.ibatis.hbatis.orm.criteria;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import plus.ibatis.hbatis.core.Criterion;
import plus.ibatis.hbatis.core.EntityNode;
import plus.ibatis.hbatis.orm.criteria.EntityOpt;
import plus.ibatis.hbatis.orm.criteria.opt.DefaultCriteriaOpt;
import plus.ibatis.hbatis.orm.criteria.opt.ICriteriaOpt;

public class Restrictions<E>
extends EntityOpt<E> {
    private List<Restriction<E>> restrictionList = new ArrayList<Restriction<E>>();

    private Restrictions(EntityNode<E> entityNode) {
        super(entityNode);
    }

    public static <E> Restrictions<E> newInstance(EntityNode<E> entityNode) {
        return new Restrictions<E>(entityNode);
    }

    public void reset() {
        this.restrictionList.clear();
    }

    private Restriction<E> restriction(String type) {
        Restriction r = null;
        if (this.restrictionList.isEmpty() || !this.restrictionList.get(this.restrictionList.size() - 1).getRelation().equals(type)) {
            r = new Restriction(type, new ArrayList());
            r.setCriterionRelation("and");
            this.restrictionList.add(r);
        } else {
            r = this.restrictionList.get(this.restrictionList.size() - 1);
        }
        return r;
    }

    protected Restrictions<E> and() {
        this.restriction("and");
        return this;
    }

    protected Restrictions<E> or() {
        this.restriction("or");
        return this;
    }

    public Restrictions<E> and(Criterion<E, ?> c) {
        this.restriction("and").getCriterions().add(c);
        return this;
    }

    public Restrictions<E> andAny(List<Criterion<E, ?>> criterions) {
        Restriction<E> r = new Restriction<E>("and", criterions);
        r.setCriterionRelation("or");
        this.restrictionList.add(r);
        return this;
    }

    public Restrictions<E> andSome(List<Criterion<E, ?>> criterions) {
        Restriction<E> r = new Restriction<E>("and", criterions);
        r.setCriterionRelation("and");
        this.restrictionList.add(r);
        return this;
    }

    public Restrictions<E> orSome(List<Criterion<E, ?>> criterions) {
        Restriction<E> r = new Restriction<E>("or", criterions);
        r.setCriterionRelation("and");
        this.restrictionList.add(r);
        return this;
    }

    public Restrictions<E> orAny(List<Criterion<E, ?>> criterions) {
        Restriction<E> r = new Restriction<E>("or", criterions);
        r.setCriterionRelation("or");
        this.restrictionList.add(r);
        return this;
    }

    public Restrictions<E> and(Criterion<E, ?> ... criteris) {
        if (criteris == null || criteris.length < 1) {
            return this;
        }
        this.andSome(Arrays.asList(criteris));
        return this;
    }

    public Restrictions<E> or(Criterion<E, ?> ... criteris) {
        if (criteris == null || criteris.length < 1) {
            return this;
        }
        this.orSome(Arrays.asList(criteris));
        return this;
    }

    public Restrictions<E> and(Consumer<ICriteriaOpt<E>> criteraOptConsumer) {
        DefaultCriteriaOpt r = new DefaultCriteriaOpt(this.getEntityNode());
        criteraOptConsumer.accept(r);
        this.and(r);
        return this;
    }

    public Restrictions<E> and(ICriteriaOpt<E> criteraOpt) {
        if (criteraOpt.getCriterions() != null && !criteraOpt.getCriterions().isEmpty()) {
            this.andSome(criteraOpt.getCriterions());
        }
        return this;
    }

    public Restrictions<E> or(Consumer<ICriteriaOpt<E>> criteraOptConsumer) {
        DefaultCriteriaOpt r = new DefaultCriteriaOpt(this.getEntityNode());
        criteraOptConsumer.accept(r);
        if (r.getCriterions() != null && !r.getCriterions().isEmpty()) {
            this.orSome(r.getCriterions());
        }
        return this;
    }

    public Restrictions<E> or(ICriteriaOpt<E> criteraOpt) {
        if (criteraOpt.getCriterions() != null && !criteraOpt.getCriterions().isEmpty()) {
            this.orSome(criteraOpt.getCriterions());
        }
        return this;
    }

    public List<Restriction<E>> getRestrictionList() {
        return this.restrictionList;
    }

    public static class Restriction<E> {
        private String relation = "and";
        private String criterionRelation = "and";
        List<Criterion<E, ?>> criterions;

        public Restriction(String relation, List<Criterion<E, ?>> crs) {
            this.relation = relation;
            this.criterions = new ArrayList(crs.size());
            this.criterions.addAll(crs);
        }

        public Restriction(String relation, Criterion<E, ?> c) {
            this.relation = relation;
            this.criterions = new ArrayList();
            this.criterions.add(c);
        }

        public String getCriterionRelation() {
            return this.criterionRelation;
        }

        public void setCriterionRelation(String criterionRelation) {
            this.criterionRelation = criterionRelation;
        }

        public String getRelation() {
            return this.relation;
        }

        public List<Criterion<E, ?>> getCriterions() {
            return this.criterions;
        }

        public void setRelation(String relation) {
            this.relation = relation;
        }
    }
}

