/*
 * Decompiled with CFR 0.152.
 */
package plus.ibatis.hbatis.orm.criteria.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ibatis.exceptions.TooManyResultsException;
import org.springframework.util.Assert;
import plus.ibatis.hbatis.core.AbstractEntityNode;
import plus.ibatis.hbatis.core.EntityNode;
import plus.ibatis.hbatis.core.FieldNode;
import plus.ibatis.hbatis.core.lambda.SFunction;
import plus.ibatis.hbatis.orm.criteria.Orders;
import plus.ibatis.hbatis.orm.criteria.Restrictions;
import plus.ibatis.hbatis.orm.criteria.statement.SelectStatement;
import plus.ibatis.hbatis.orm.criteria.support.AbstractOrderedEntityQuery;
import plus.ibatis.hbatis.orm.criteria.support.StatementBuilder;
import plus.ibatis.hbatis.orm.mapper.HbatisStatementMapper;

public class EntityQuery<T>
extends AbstractOrderedEntityQuery<T> {
    private HbatisStatementMapper<T> mapper;
    SelectStatement<T> st;

    public EntityQuery(HbatisStatementMapper<T> mapper, EntityNode<T> n) {
        super(n);
        this.mapper = mapper;
        this.st = StatementBuilder.buildSelect(n);
    }

    public final EntityQuery<T> select(FieldNode ... field) {
        this.st.setFields(Arrays.asList(field));
        return this;
    }

    public final EntityQuery<T> select(List<FieldNode<T, ?>> fields) {
        this.st.setFields(fields);
        return this;
    }

    @SafeVarargs
    public final EntityQuery<T> select(SFunction<T, ?> ... func) {
        ArrayList selectFields = new ArrayList(func.length);
        for (SFunction<T, ?> tmp : func) {
            String prop = this.prop(tmp);
            FieldNode fn = this.field(prop);
            selectFields.add(fn);
        }
        return this;
    }

    public final EntityQuery<T> select(String ... prop) {
        ArrayList selectFields = new ArrayList();
        for (String tmp : prop) {
            FieldNode fn = this.field(tmp);
            selectFields.add(fn);
        }
        this.st.setFields(selectFields);
        return this;
    }

    public EntityQuery<T> limit(int limit) {
        this.st.setPageRange(0, limit);
        return this;
    }

    public EntityQuery<T> limit(int start, int limit) {
        this.st.setPageRange(start, limit);
        return this;
    }

    public void nextPage() {
        Assert.notNull((Object)this.st.getPageRange(), (String)"Page params not setted");
        Assert.isTrue((this.st.getPageRange().getLimit() > 0 ? 1 : 0) != 0, (String)"Limit of page params should greater then 0");
        this.st.getPageRange().setStart(this.st.getPageRange().getStart() + this.st.getPageRange().getLimit());
    }

    public List<T> fetch() {
        return this.mapper.selectByStatement(this.st);
    }

    public T fetchOne() {
        List<T> tmp = this.mapper.selectByStatement(this.st);
        if (tmp == null || tmp.isEmpty()) {
            return null;
        }
        if (tmp.size() > 1) {
            throw new TooManyResultsException("Expect fetch 1,but fetch " + tmp.size());
        }
        return tmp.get(0);
    }

    public T fetchFirst() {
        List<T> tmp = this.mapper.selectByStatement(this.st);
        if (tmp == null || tmp.isEmpty()) {
            return null;
        }
        return tmp.get(0);
    }

    public long count() {
        return this.mapper.countByRestrictions(this.st.restrictions());
    }

    @Override
    public Restrictions<T> getRestrictions() {
        return this.st.restrictions();
    }

    @Override
    public Orders<T> getOrders() {
        return this.st.orderby();
    }

    public static <T> EntityQuery<T> create(HbatisStatementMapper<T> repo, EntityNode<T> n) {
        return new EntityQuery<T>(repo, n);
    }

    public static <T> EntityQuery<T> create(HbatisStatementMapper<T> repo, Class<T> clazz) {
        return EntityQuery.create(repo, AbstractEntityNode.of(clazz));
    }

    public Orders<T> orderBy(Orders<T> orders) {
        this.st.orderby(orders);
        return this.st.orderby();
    }

    public Orders<T> orderBy() {
        return this.st.orderby();
    }
}

