/*
 * Decompiled with CFR 0.152.
 */
package plus.ibatis.hbatis.orm.criteria.support.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.util.Assert;
import plus.ibatis.hbatis.core.AbstractEntityNode;
import plus.ibatis.hbatis.core.Criterion;
import plus.ibatis.hbatis.core.EntityNode;
import plus.ibatis.hbatis.core.FieldNode;
import plus.ibatis.hbatis.core.meta.FieldMeta;
import plus.ibatis.hbatis.orm.criteria.Orders;
import plus.ibatis.hbatis.orm.criteria.SortOrder;
import plus.ibatis.hbatis.orm.criteria.support.query.FieldConditionMapping;
import plus.ibatis.hbatis.orm.criteria.support.query.FieldConditionProcessor;

public abstract class AbstractQueryParam<T> {
    public static final int LIMIT = 20;
    private Integer start = 0;
    private Integer limit = 20;
    private Orders<T> orders;
    private List<Criterion<T, ?>> conditions = new ArrayList();
    private FieldConditionProcessor conditionProcessor;
    private Map<String, Object> param = new HashMap<String, Object>();
    private boolean optimize = true;
    private EntityNode<T> entityNode;

    public Map<String, Object> getParam() {
        return this.param;
    }

    public void setParam(Map<String, Object> param) {
        this.param = param;
    }

    public void setPagination(int start, int limit) {
        this.start = start;
        this.limit = limit;
    }

    public Integer getStart() {
        return this.start;
    }

    public void setStart(Integer start) {
        this.start = start;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public AbstractQueryParam<T> nextPage() {
        Assert.notNull((Object)this.getStart(), (String)"Start of page params not setted");
        Assert.notNull((Object)this.getLimit(), (String)"Limit of page params not setted");
        Assert.isTrue((this.getLimit() > 0 ? 1 : 0) != 0, (String)"Limit of page params should greater then 0");
        this.start = this.start + this.limit;
        return this;
    }

    public void setOptimize(boolean optimize) {
        this.optimize = optimize;
    }

    public List<SortOrder> getSortOrders() {
        return this.orders().getOrderList();
    }

    public Orders<T> orders() {
        if (this.orders == null) {
            this.orders = Orders.newInstance(this.entityNode);
        }
        return this.orders;
    }

    public AbstractQueryParam<T> orderDesc(FieldNode<T, ?> fn) {
        this.orders().desc(fn);
        return this;
    }

    public AbstractQueryParam<T> orderAsc(FieldNode<T, ?> fn) {
        this.orders().asc(fn);
        return this;
    }

    public List<Criterion<T, ?>> getConditions() {
        if (!this.optimize) {
            return this.conditions;
        }
        this.conditions.sort((a, b) -> {
            FieldMeta aMeta = a.getFieldNode().getFieldMeta();
            FieldMeta bMeta = b.getFieldNode().getFieldMeta();
            if (aMeta.isPrimaryKey()) {
                return -1;
            }
            int flag = aMeta.isIndexed() ^ bMeta.isIndexed() ? (aMeta.isIndexed() ? -1 : 1) : 0;
            return flag;
        });
        return this.conditions;
    }

    public void putConditions(Map map, EntityNode node) {
        FieldConditionMapping.process(map, this, this.conditionProcessor, node);
    }

    public void setConditionConversion(FieldConditionProcessor conditionConversion) {
        this.conditionProcessor = conditionConversion;
    }

    private Criterion createCondition(EntityNode node, String fieldName, Object value) {
        FieldNode fieldNode = node.getFieldNode(fieldName);
        return fieldNode.eq(value);
    }

    public void addCondition(EntityNode node, String fieldName, Object value) {
        Criterion c = this.createCondition(node, fieldName, value);
        this.addCondition(c);
    }

    public void addCondition(String fieldName, Object value) {
        Criterion cnd = this.createCondition(this.entityNode, fieldName, value);
        this.conditions.add(cnd);
    }

    public void putCondition(EntityNode node, String fieldName, Object value) {
        Criterion c = node.getFieldNode(fieldName).eq(value);
        this.putCondition(c);
    }

    public void putCondition(String fieldName, Object value) {
        this.putCondition(this.entityNode, fieldName, value);
    }

    public void removeConditions(String[] fieldNames) {
        Iterator<Criterion<T, ?>> it = this.conditions.iterator();
        List<String> props = Arrays.asList(fieldNames);
        while (it.hasNext()) {
            Criterion<T, ?> tmp = it.next();
            String propName = tmp.getFieldNode().getPropertyName();
            if (!tmp.getFieldNode().getEntityPath().equals(this.entityNode) || !props.contains(propName)) continue;
            it.remove();
        }
    }

    public void removeConditions(FieldNode ... node) {
        Iterator<Criterion<T, ?>> it = this.conditions.iterator();
        List<FieldNode> nodes = Arrays.asList(node);
        while (it.hasNext()) {
            Criterion<T, ?> tmp = it.next();
            if (!nodes.contains(tmp.getFieldNode())) continue;
            it.remove();
        }
    }

    public void removeAllConditions() {
        this.conditions.clear();
    }

    public void putCondition(Criterion c) {
        Iterator<Criterion<T, ?>> it = this.conditions.iterator();
        while (it.hasNext()) {
            Criterion<T, ?> tmp = it.next();
            if (!tmp.getFieldNode().getSqlColumn().equals(c.getFieldNode().getSqlColumn()) || !tmp.getOpKey().equals(c.getOpKey())) continue;
            it.remove();
        }
        this.conditions.add(c);
    }

    public void addCondition(Criterion c) {
        this.conditions.add(c);
    }

    public void setOrderBys(String str) {
        this.orders = Orders.fromString(this.entityNode, str);
    }

    public String getOrderBys() {
        return this.orders().toString();
    }

    @Deprecated
    public String getSortBys() {
        return this.orders().toString();
    }

    @Deprecated
    public void setSortBys(String str) {
        this.orders = Orders.fromString(this.entityNode, str);
    }

    public Set<String> getValueFields() {
        return this.conditions.stream().map(c -> c.getFieldNode().getEntityPath().getEntityMeta().getEntityClass().getSimpleName()).collect(Collectors.toSet());
    }

    public boolean containsValueField(String field) {
        Set<String> valueFields = this.getValueFields();
        return valueFields.contains(field);
    }

    public <V> FieldNode<T, V> field(String field) {
        return this.entityNode.getFieldNode(field);
    }

    public EntityNode<T> getEntityNode() {
        return this.entityNode;
    }

    public AbstractQueryParam(Class<T> clazz) {
        this.entityNode = AbstractEntityNode.of(clazz);
    }

    public AbstractQueryParam(EntityNode<T> node) {
        this.entityNode = node;
    }
}

