/*
 * Decompiled with CFR 0.152.
 */
package plus.ibatis.hbatis.orm.criteria.support.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import plus.ibatis.hbatis.core.Criterion;
import plus.ibatis.hbatis.core.CriterionOpts;
import plus.ibatis.hbatis.core.FieldNode;
import plus.ibatis.hbatis.orm.criteria.support.query.FieldConditionProcessor;

public class DefaultFieldConditionProcessor
implements FieldConditionProcessor {
    protected static DefaultFieldConditionProcessor INSTANCE = new DefaultFieldConditionProcessor();

    public static DefaultFieldConditionProcessor getInstance() {
        return INSTANCE;
    }

    @Override
    public <E> List<Criterion> process(FieldNode<E, ?> fn, String prop, Object fieldValue) {
        if (fieldValue == null) {
            return this.processNullValue(fn, prop);
        }
        if (fieldValue instanceof String) {
            return this.processStringValue(fn, prop, fieldValue);
        }
        if (fieldValue instanceof Number) {
            return this.processNumberValue(fn, prop, fieldValue);
        }
        if (fieldValue instanceof Boolean) {
            return this.processBooleanValue(fn, prop, fieldValue);
        }
        if (fieldValue instanceof Date) {
            return this.processDateValue(fn, prop, fieldValue);
        }
        if (fieldValue instanceof Byte) {
            return this.processByteValue(fn, prop, fieldValue);
        }
        if (fieldValue instanceof Map) {
            return this.processMapValue(fn, prop, fieldValue);
        }
        if (fieldValue instanceof Collection) {
            return this.processCollectionValue(fn, prop, fieldValue);
        }
        return this.processUnknownType(fn, prop, fieldValue);
    }

    private List<Criterion> processNullValue(FieldNode fn, String prop) {
        Criterion cnd = fn.isNull();
        return Arrays.asList(cnd);
    }

    private <E> List<Criterion> processDateValue(FieldNode fn, String prop, Object fieldValue) {
        Criterion cnd = fn.eq(fieldValue);
        return Arrays.asList(cnd);
    }

    protected <E> List<Criterion> processStringValue(FieldNode fn, String prop, Object fieldValue) {
        Criterion cnd = fn.eq(fieldValue);
        return Arrays.asList(cnd);
    }

    protected <E> List<Criterion> processNumberValue(FieldNode fn, String prop, Object fieldValue) {
        Criterion cnd = fn.eq(fieldValue);
        return Arrays.asList(cnd);
    }

    protected <E> List<Criterion> processByteValue(FieldNode fn, String prop, Object fieldValue) {
        Criterion cnd = fn.eq(fieldValue);
        return Arrays.asList(cnd);
    }

    protected <E> List<Criterion> processBooleanValue(FieldNode fn, String prop, Object fieldValue) {
        Criterion cnd = fn.eq(fieldValue);
        return Arrays.asList(cnd);
    }

    protected <E> List<Criterion> processUnknownType(FieldNode<E, ?> fn, String prop, Object fieldValue) {
        return Collections.emptyList();
    }

    protected <E> List<Criterion> processCollectionValue(FieldNode fn, String prop, Object fieldValue) {
        Criterion cnd = fn.in((List)fieldValue);
        return Arrays.asList(cnd);
    }

    protected <E> List<Criterion> processMapValue(FieldNode fn, String prop, Object fieldValue) {
        Map cnds = (Map)fieldValue;
        ArrayList<Criterion> rs = new ArrayList<Criterion>(cnds.size());
        for (Map.Entry entry : cnds.entrySet()) {
            String op = (String)entry.getKey();
            Object value = entry.getValue();
            Criterion cItem = null;
            CriterionOpts opt = CriterionOpts.match(op.toLowerCase());
            if (opt == null) {
                throw new IllegalArgumentException("No operation named " + op);
            }
            if (value == null) {
                if (!CriterionOpts.IS.equals((Object)opt) && !CriterionOpts.NIS.equals((Object)opt)) continue;
                cItem = new Criterion(fn, opt, value);
                continue;
            }
            if (!opt.isValueCollection()) {
                cItem = new Criterion(fn, opt, value);
            } else {
                List vals = (List)value;
                cItem = CriterionOpts.BETWEEN.getValue().equals(op) || CriterionOpts.NBETWEEN.getValue().equals(op) ? new Criterion(fn, opt, vals.get(0), vals.get(1)) : new Criterion(fn, opt, value);
            }
            if (cItem == null) continue;
            rs.add(cItem);
        }
        return rs;
    }
}

