/*
 * Decompiled with CFR 0.152.
 */
package plus.ibatis.hbatis.orm.criteria.support.query;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plus.ibatis.hbatis.core.Criterion;
import plus.ibatis.hbatis.core.EntityNode;
import plus.ibatis.hbatis.core.FieldNode;
import plus.ibatis.hbatis.orm.criteria.support.query.AbstractQueryParam;
import plus.ibatis.hbatis.orm.criteria.support.query.DefaultFieldConditionProcessor;
import plus.ibatis.hbatis.orm.criteria.support.query.FieldConditionProcessor;

class FieldConditionMapping {
    private static final Logger logger = LoggerFactory.getLogger(FieldConditionMapping.class);

    FieldConditionMapping() {
    }

    public static void process(Map<String, Object> params, AbstractQueryParam r, FieldConditionProcessor processor) {
        FieldConditionMapping.process(params, r, processor, r.getEntityNode());
    }

    public static void process(Map<String, Object> params, AbstractQueryParam r, FieldConditionProcessor processor, EntityNode n) {
        if (params == null || params.isEmpty()) {
            return;
        }
        List fieldNodes = n.getFieldNodes();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            List<Criterion> cnds;
            String prop = entry.getKey();
            Object value = entry.getValue();
            if (value == null || FieldConditionMapping.isEmpty(value)) continue;
            FieldNode fn = fieldNodes.stream().filter(o -> o.getFieldMeta().getPropertyName().equals(prop)).findFirst().orElse(null);
            if (fn == null) {
                logger.warn("Property not exists [property:{}],this condition will be skiped.", (Object)prop);
                continue;
            }
            if (processor == null) {
                processor = DefaultFieldConditionProcessor.getInstance();
            }
            if ((cnds = processor.process(fn, prop, value)) == null) continue;
            for (Criterion c : cnds) {
                r.addCondition(c);
            }
        }
    }

    private static boolean isEmpty(Object value) {
        if (value instanceof String && value.toString().trim().length() < 1) {
            return true;
        }
        if (value instanceof Collection && ((Collection)value).isEmpty()) {
            return true;
        }
        return value instanceof Map && ((Map)value).isEmpty();
    }
}

