/*
 * Decompiled with CFR 0.152.
 */
package plus.ibatis.hbatis.orm.sql;

import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.mapping.ResultFlag;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.session.Configuration;
import plus.ibatis.hbatis.core.meta.FieldMeta;
import plus.ibatis.hbatis.core.metaDescriber.EntityClassDescriber;
import plus.ibatis.hbatis.core.metaDescriber.EntityFieldDescriber;

public class ResultMapsBuilder {
    private ResultMapsBuilder() {
    }

    public static <E> List<ResultMapping> buildResultMappings(Configuration configuration, EntityClassDescriber<E> mapping) {
        List<EntityFieldDescriber> keyFields = mapping.getPrimaryKeys();
        ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
        List<EntityFieldDescriber> fields = mapping.getFieldDescribers();
        for (EntityFieldDescriber fieldD : fields) {
            FieldMeta field = fieldD.getFieldMeta();
            String columnName = field.getColumnName();
            ResultMapping.Builder builder = new ResultMapping.Builder(configuration, field.getPropertyName(), columnName, field.getFieldType());
            resultMappings.add(builder.build());
            if (!ResultMapsBuilder.isPrimaryKey(keyFields, field.getPropertyName())) continue;
            ArrayList<ResultFlag> flags = new ArrayList<ResultFlag>();
            ResultFlag flag = ResultFlag.ID;
            flags.add(flag);
            builder.flags(flags);
        }
        return resultMappings;
    }

    private static boolean isPrimaryKey(List<EntityFieldDescriber> keyFields, String property) {
        for (EntityFieldDescriber keyField : keyFields) {
            if (!keyField.getField().getName().equals(property)) continue;
            return true;
        }
        return false;
    }

    public static <E> ResultMap buildResultMap(String resultMapId, Configuration configuration, EntityClassDescriber<E> mapping) {
        Class<E> entityClass = mapping.getEntityMeta().getEntityClass();
        List<ResultMapping> resultMappings = ResultMapsBuilder.buildResultMappings(configuration, mapping);
        ResultMap.Builder builder = new ResultMap.Builder(configuration, resultMapId, entityClass, resultMappings);
        ResultMap rm = builder.build();
        return rm;
    }
}

