/*
 * Decompiled with CFR 0.152.
 */
package plus.ibatis.hbatis.orm.sql.builder;

import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.SqlCommandType;
import plus.ibatis.hbatis.core.meta.FieldMeta;
import plus.ibatis.hbatis.orm.sql.AbstractSqlBuilder;
import plus.ibatis.hbatis.orm.util.SqlBuilderHelper;

public class InsertSelectiveSqlBuilder
extends AbstractSqlBuilder {
    public InsertSelectiveSqlBuilder(SqlSourceBuilder sqlSourceBuilder, Class<?> clazz) {
        super(sqlSourceBuilder, clazz);
    }

    @Override
    public <E> String buildSql() {
        StringBuilder sb = new StringBuilder();
        String tableName = this.getEntityMeta().getTableName();
        sb.append("insert into ").append(tableName).append("(");
        List fields = this.getFieldMetas();
        ArrayList insertFields = new ArrayList();
        sb.append("<trim suffixOverrides=\",\">");
        for (FieldMeta fieldMeta : fields) {
            if (!fieldMeta.isInsertable()) continue;
            insertFields.add(fieldMeta);
            sb.append("<if test=\"").append(fieldMeta.getPropertyName()).append("!=null\">");
            sb.append("`").append(fieldMeta.getColumnName()).append("`,");
            sb.append("</if>");
        }
        sb.append("</trim>");
        sb.append(") values (");
        sb.append("<trim suffixOverrides=\",\">");
        for (int i = 0; i < insertFields.size(); ++i) {
            FieldMeta fieldMeta = (FieldMeta)insertFields.get(i);
            sb.append("<if test=\"").append(fieldMeta.getPropertyName()).append("!=null\">");
            sb.append("#{").append(fieldMeta.getPropertyName()).append(",jdbcType=").append((Object)fieldMeta.getJdbcType()).append("}").append(",");
            sb.append("</if>");
        }
        sb.append("</trim>");
        sb.append(")");
        return sb.toString();
    }

    @Override
    public BoundSql getBoundSql(Object parameter) {
        String sqlSourceId = this.entityClass.getName() + ":insertSelective";
        return SqlBuilderHelper.getScriptSqlSourceIfAbsent(sqlSourceId, this.entityClass, this.sqlSourceBuilder.getConfiguration(), cfg -> this.sqlTpl).getBoundSql(parameter);
    }

    @Override
    public SqlCommandType getSqlCommandType() {
        return SqlCommandType.INSERT;
    }
}

