/*
 * Decompiled with CFR 0.152.
 */
package plus.ibatis.hbatis.orm.util;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.scripting.xmltags.XMLScriptBuilder;
import org.apache.ibatis.session.Configuration;
import plus.ibatis.hbatis.core.meta.FieldMeta;
import plus.ibatis.hbatis.core.metaDescriber.EntityClassDescriber;
import plus.ibatis.hbatis.core.metaDescriber.EntityFieldDescriber;
import plus.ibatis.hbatis.orm.util.XNodeUtil;

public class SqlBuilderHelper {
    private static Map<String, SqlSource> sqlCache = new ConcurrentHashMap<String, SqlSource>();

    private SqlBuilderHelper() {
    }

    public static String buildPrimaryWhereSql(EntityClassDescriber<?> mapping) {
        StringBuilder sb = new StringBuilder();
        List<EntityFieldDescriber> keyFields = mapping.getPrimaryKeys();
        int keyIndex = 0;
        for (EntityFieldDescriber fd : keyFields) {
            if (keyIndex > 0) {
                sb.append(" and ");
            }
            String prop = fd.getField().getName();
            FieldMeta fm = fd.getFieldMeta();
            sb.append(fm.getColumnName()).append("=");
            sb.append("#{").append(prop).append(",jdbcType=").append((Object)fm.getJdbcType()).append("}");
            ++keyIndex;
        }
        return sb.toString();
    }

    public static SqlSource buildScriptSqlSource(String sqlSourceId, String sqlScript, Class<?> paramType, Configuration configuration) {
        SqlSource sqlSource = sqlCache.get(sqlSourceId);
        if (sqlSource != null) {
            return sqlSource;
        }
        XNode xnode = XNodeUtil.getRootNode("<script>" + sqlScript + "</script>");
        XMLScriptBuilder scriptBuilder = new XMLScriptBuilder(configuration, xnode, paramType);
        sqlSource = scriptBuilder.parseScriptNode();
        sqlCache.put(sqlSourceId, sqlSource);
        return sqlSource;
    }

    public static SqlSource getScriptSqlSource(String sqlSourceId) {
        SqlSource sqlSource = sqlCache.get(sqlSourceId);
        return sqlSource;
    }

    public static SqlSource getScriptSqlSourceIfAbsent(String sqlSourceId, Class<?> paramType, Configuration cfg, Function<Configuration, String> fn) {
        SqlSource sqlSource = sqlCache.get(sqlSourceId);
        if (sqlSource != null) {
            return sqlSource;
        }
        String sqlScript = fn.apply(cfg);
        XNode xnode = XNodeUtil.getRootNode("<script>" + sqlScript + "</script>");
        XMLScriptBuilder scriptBuilder = new XMLScriptBuilder(cfg, xnode, paramType);
        sqlSource = scriptBuilder.parseScriptNode();
        sqlCache.put(sqlSourceId, sqlSource);
        return sqlSource;
    }
}

