/*
 * Decompiled with CFR 0.152.
 */
package plus.ibatis.hbatis.plugins;

import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Invocation;
import plus.ibatis.hbatis.plugins.Metas;

public class InnerInterceptorContext {
    private MappedStatement mappedStatement;
    private Invocation invocation;
    private Executor executor;
    private Object parameter;
    private BoundSql boundSql;
    private Object invokedResult;
    private boolean sqlChanged = false;

    public InnerInterceptorContext(Invocation invocation) {
        this.invocation = invocation;
        Object target = invocation.getTarget();
        Object[] args = invocation.getArgs();
        if (target instanceof Executor) {
            this.executor = (Executor)invocation.getTarget();
            this.mappedStatement = (MappedStatement)invocation.getArgs()[0];
            this.parameter = args[1];
            this.boundSql = this.mappedStatement.getBoundSql(this.parameter);
        } else {
            StatementHandler handler = (StatementHandler)invocation.getTarget();
            this.boundSql = handler.getBoundSql();
            this.mappedStatement = Metas.statementHandler(handler).mappedStatement();
        }
    }

    public boolean isSqlChanged() {
        return this.sqlChanged;
    }

    public void setSqlChanged(boolean sqlChanged) {
        this.sqlChanged = sqlChanged;
    }

    public Object getInvokedResult() {
        return this.invokedResult;
    }

    public void setInvokedResult(Object invokedResult) {
        this.invokedResult = invokedResult;
    }

    public SqlCommandType getSqlCommandType() {
        return this.mappedStatement.getSqlCommandType();
    }

    public MappedStatement getMappedStatement() {
        return this.mappedStatement;
    }

    public Invocation getInvocation() {
        return this.invocation;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public Object getParameter() {
        return this.parameter;
    }

    public BoundSql getBoundSql() {
        return this.boundSql;
    }
}

