/*
 * Decompiled with CFR 0.152.
 */
package plus.ibatis.hbatis.plugins;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlSource;
import plus.ibatis.hbatis.plugins.Dialect;

public class PluginUtils {
    private static final Log logger = LogFactory.getLog(PluginUtils.class);
    private static final Map<String, Dialect> JDBC_DB_TYPE_CACHE = new ConcurrentHashMap<String, Dialect>();

    public static Dialect getDialect(Executor executor) {
        try {
            Connection conn = executor.getTransaction().getConnection();
            return JDBC_DB_TYPE_CACHE.computeIfAbsent(conn.getMetaData().getURL(), k -> PluginUtils.getDialect(k));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static Dialect getDialect(String jdbcUrl) {
        String url = jdbcUrl.toLowerCase();
        if (url.contains(":mysql:") || url.contains(":cobar:")) {
            return Dialect.mysql;
        }
        if (url.contains(":mariadb:")) {
            return Dialect.mariadb;
        }
        if (url.contains(":oracle:")) {
            return Dialect.oracle;
        }
        if (url.contains(":sqlserver:") || url.contains(":microsoft:")) {
            return Dialect.sqlserver;
        }
        if (url.contains(":sqlserver2012:")) {
            return Dialect.sqlserver2012;
        }
        if (url.contains(":postgresql:")) {
            return Dialect.postgresql;
        }
        if (url.contains(":hsqldb:")) {
            return Dialect.hsqldb;
        }
        if (url.contains(":db2:")) {
            return Dialect.db2;
        }
        if (url.contains(":sqlite:")) {
            return Dialect.sqlite;
        }
        if (url.contains(":h2:")) {
            return Dialect.h2;
        }
        logger.warn("The jdbcUrl is " + jdbcUrl + ", Mybatis Plus Cannot Read Database type or The Database's Not Supported!");
        return Dialect.other;
    }

    public static MappedStatement newMappedStatement(MappedStatement mappedStatement, BoundSql boundSql, String sql) {
        BoundSql newBoundSql = new BoundSql(mappedStatement.getConfiguration(), sql, boundSql.getParameterMappings(), boundSql.getParameterObject());
        MappedStatement newMs = PluginUtils.copyFromMappedStatement(mappedStatement, new BoundSqlSqlSource(newBoundSql));
        for (ParameterMapping mapping : boundSql.getParameterMappings()) {
            String prop = mapping.getProperty();
            if (!boundSql.hasAdditionalParameter(prop)) continue;
            newBoundSql.setAdditionalParameter(prop, boundSql.getAdditionalParameter(prop));
        }
        return newMs;
    }

    private static MappedStatement copyFromMappedStatement(MappedStatement ms, SqlSource newSqlSource) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), ms.getId(), newSqlSource, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        if (ms.getKeyProperties() != null && ms.getKeyProperties().length > 0) {
            builder.keyProperty(ms.getKeyProperties()[0]);
        }
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        builder.resultMaps(ms.getResultMaps());
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }

    public static <T> T readXml(InputStream is, Class<T> clazz) throws JAXBException {
        Object t = null;
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        t = unmarshaller.unmarshal(is);
        return (T)t;
    }

    public static class BoundSqlSqlSource
    implements SqlSource {
        private BoundSql boundSql;

        public BoundSqlSqlSource(BoundSql boundSql) {
            this.boundSql = boundSql;
        }

        public BoundSql getBoundSql(Object parameterObject) {
            return this.boundSql;
        }
    }
}

