/*
 * Decompiled with CFR 0.152.
 */
package plus.ibatis.hbatis.plugins.dataPermisson;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.apache.ibatis.mapping.MappedStatement;
import plus.ibatis.hbatis.plugins.dataPermisson.DataScopeDefine;
import plus.ibatis.hbatis.plugins.dataPermisson.DataScopeStatementRegistry;
import plus.ibatis.hbatis.plugins.dataPermisson.annotations.DataColumn;
import plus.ibatis.hbatis.plugins.dataPermisson.annotations.DataScope;
import plus.ibatis.hbatis.plugins.dataPermisson.annotations.DataScopeIgnore;

class DataScopeStatementHolder {
    private static Set<String> statementReadFlag = new HashSet<String>();

    private DataScopeStatementHolder() {
    }

    public static DataScopeDefine getDataScopeDefine(MappedStatement ms) {
        DataScope ds;
        String statementId = ms.getId();
        DataScopeDefine define = DataScopeStatementRegistry.getDefine(statementId);
        if (define != null) {
            return define;
        }
        if (statementReadFlag.contains(statementId)) {
            return define;
        }
        try {
            ds = DataScopeStatementHolder.readDataScope(ms);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        statementReadFlag.add(statementId);
        if (ds == null) {
            return null;
        }
        DataScopeDefine dsDef = new DataScopeDefine();
        dsDef.setId(statementId);
        CharSequence[] globalCodes = ds.withScopes();
        if (globalCodes != null && globalCodes.length > 0) {
            dsDef.setWithScopes(String.join((CharSequence)",", globalCodes));
        }
        for (DataColumn dc : ds.values()) {
            DataScopeDefine.Definition def = new DataScopeDefine.Definition();
            def.setKey(dc.key());
            def.setColumnAlias(dc.alias());
            def.setColumn(dc.column());
            def.setDataType(dc.dataType());
            dsDef.addDefinition(def);
        }
        DataScopeStatementRegistry.regist(statementId, dsDef);
        return dsDef;
    }

    private static DataScope readDataScope(MappedStatement ms) throws ClassNotFoundException {
        Method[] methods;
        String statementId = ms.getId();
        String className = statementId.substring(0, statementId.lastIndexOf("."));
        String methodName = statementId.substring(statementId.lastIndexOf(".") + 1);
        Class<?> cla = Class.forName(className);
        for (Method m : methods = cla.getMethods()) {
            DataScopeIgnore dsIgnore;
            if (!m.getName().equals(methodName)) continue;
            if (m.isAnnotationPresent(DataScopeIgnore.class) && (dsIgnore = m.getAnnotation(DataScopeIgnore.class)).value()) {
                return null;
            }
            return m.getAnnotation(DataScope.class);
        }
        return null;
    }
}

