/*
 * Decompiled with CFR 0.152.
 */
package plus.ibatis.hbatis.plugins.dataPermisson;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plus.ibatis.hbatis.plugins.PluginUtils;
import plus.ibatis.hbatis.plugins.dataPermisson.DataScopeDefine;

public class DataScopeStatementRegistry {
    private static final Logger log = LoggerFactory.getLogger(DataScopeStatementRegistry.class);
    private static Map<String, DataScopeDefine> statementDataScope = new ConcurrentHashMap<String, DataScopeDefine>();
    private static Map<String, DataScopeDefine> globalDataScope = new ConcurrentHashMap<String, DataScopeDefine>();

    private DataScopeStatementRegistry() {
    }

    public static boolean containsDefine(String statementId) {
        return statementDataScope.containsKey(statementId);
    }

    public static DataScopeDefine getDefine(String statementId) {
        return statementDataScope.get(statementId);
    }

    public static void regist(String statementId, DataScopeDefine define) {
        if (define.getWithScopes() != null) {
            String[] scopes;
            for (String scope : scopes = define.getWithScopes().split(",")) {
                DataScopeDefine gs = DataScopeStatementRegistry.getGlobal(scope);
                DataScopeStatementRegistry.mergeGlobalDefine(gs, define);
            }
        }
        log.info("Regist datascope :{}", (Object)define);
        statementDataScope.put(statementId, define);
    }

    private static DataScopeDefine mergeGlobalDefine(DataScopeDefine globalDef, DataScopeDefine define) {
        if (globalDef == null || globalDef.isEmpty()) {
            return define;
        }
        for (DataScopeDefine.Definition gd : globalDef.getDefinitions()) {
            DataScopeDefine.Definition d = define.getDefinition(gd.getKey());
            if (d != null) continue;
            define.addDefinition(gd);
        }
        return define;
    }

    public static void registGlobal(String code, DataScopeDefine define) {
        log.info("Regist global datascope :{}", (Object)define);
        globalDataScope.put(code, define);
    }

    public static DataScopeDefine getGlobal(String code) {
        return globalDataScope.get(code);
    }

    public static void registFromClassPath(String xmlClassPath) {
        List<DataScopeDefine> sts;
        List<DataScopeDefine> gsDefines;
        log.debug("Regist datascope defines by path:{}", (Object)xmlClassPath);
        InputStream in = DataScopeStatementRegistry.class.getClassLoader().getClass().getResourceAsStream(xmlClassPath);
        if (in == null) {
            log.info("DataScope resource not exists!");
            return;
        }
        DefinitionDoc doc = null;
        try {
            doc = PluginUtils.readXml(in, DefinitionDoc.class);
        }
        catch (JAXBException e) {
            throw new RuntimeException("Read datascope definition error", e);
        }
        List<DataScopeDefine> list = gsDefines = doc.getGlobalScopes() == null ? null : doc.getGlobalScopes().getScopeDefines();
        if (gsDefines != null) {
            for (DataScopeDefine r : gsDefines) {
                DataScopeStatementRegistry.registGlobal(r.getId(), r);
            }
        }
        List<DataScopeDefine> list2 = sts = doc.getScopeStatements() == null ? null : doc.getScopeStatements().getScopeDefines();
        if (sts != null) {
            for (DataScopeDefine r : sts) {
                DataScopeStatementRegistry.regist(r.getId(), r);
            }
        }
    }

    static {
        DataScopeStatementRegistry.registFromClassPath("/META-INF/dataScope.xml");
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class ScopeStatements {
        @XmlElements(value={@XmlElement(name="statement")})
        private List<DataScopeDefine> scopeDefines;

        ScopeStatements() {
        }

        public List<DataScopeDefine> getScopeDefines() {
            return this.scopeDefines;
        }

        public void setScopeDefines(List<DataScopeDefine> scopeDefines) {
            this.scopeDefines = scopeDefines;
        }
    }

    @XmlRootElement(name="root")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class DefinitionDoc {
        @XmlElement(name="global")
        private ScopeStatements globalScopes;
        @XmlElement(name="statements")
        private ScopeStatements scopeStatements;

        DefinitionDoc() {
        }

        public ScopeStatements getScopeStatements() {
            return this.scopeStatements;
        }

        public ScopeStatements getGlobalScopes() {
            return this.globalScopes;
        }

        public void setGlobalScopes(ScopeStatements globalScopes) {
            this.globalScopes = globalScopes;
        }
    }
}

