/*
 * Decompiled with CFR 0.152.
 */
package plus.ibatis.hbatis.plugins.dataPermisson;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SubSelect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plus.ibatis.hbatis.plugins.InnerInterceptorContext;
import plus.ibatis.hbatis.plugins.dataPermisson.DataScopeContext;
import plus.ibatis.hbatis.plugins.dataPermisson.DataScopeDefine;
import plus.ibatis.hbatis.plugins.dataPermisson.DataScopeSqlProcessor;

public class DefaultDataScopeSqlProcessor
implements DataScopeSqlProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultDataScopeSqlProcessor.class);

    @Override
    public void process(SelectBody selectBody, DataScopeDefine scopeDefine, InnerInterceptorContext ctx) throws JSQLParserException {
        List<String> segs = this.processSelectBody(selectBody, scopeDefine);
        if (segs != null && segs.size() > 0) {
            ctx.setSqlChanged(true);
            segs.clear();
            segs = null;
        }
    }

    public List<String> processSelectBody(SelectBody selectBody, DataScopeDefine scopeDefine) throws JSQLParserException {
        List<String> tmp;
        if (!(selectBody instanceof PlainSelect)) {
            return null;
        }
        ArrayList<String> allSegs = new ArrayList<String>();
        PlainSelect plainSelect = (PlainSelect)selectBody;
        FromItem fromItem = plainSelect.getFromItem();
        List joins = plainSelect.getJoins();
        boolean isProceedTable = false;
        if (fromItem instanceof SubSelect) {
            SubSelect subSelect = (SubSelect)fromItem;
            List<String> tmp2 = this.processSelectBody(subSelect.getSelectBody(), scopeDefine);
            if (tmp2 != null) {
                allSegs.addAll(tmp2);
            }
        } else if (fromItem instanceof Table && (tmp = this.setWhere(plainSelect, (Table)fromItem, scopeDefine)) != null) {
            isProceedTable = true;
            allSegs.addAll(tmp);
        }
        if (joins != null) {
            for (Join join : joins) {
                List<String> tmp3;
                FromItem rightFromItem = join.getRightItem();
                if (rightFromItem instanceof SubSelect) {
                    SubSelect subSelect = (SubSelect)rightFromItem;
                    List<String> tmp4 = this.processSelectBody(subSelect.getSelectBody(), scopeDefine);
                    if (tmp4 == null) continue;
                    allSegs.addAll(tmp4);
                    continue;
                }
                if (!(rightFromItem instanceof Table) || isProceedTable || (tmp3 = this.setWhere(plainSelect, (Table)rightFromItem, scopeDefine)) == null) continue;
                allSegs.addAll(tmp3);
            }
        }
        return allSegs;
    }

    private List<String> setWhere(PlainSelect plainSelect, Table table, DataScopeDefine scopeDefine) throws JSQLParserException {
        List<String> sqlSegs = this.createExpressions(table, scopeDefine);
        if (sqlSegs == null || sqlSegs.isEmpty()) {
            return null;
        }
        Expression where = plainSelect.getWhere();
        if (where == null) {
            plainSelect.setWhere(CCJSqlParserUtil.parseCondExpression((String)sqlSegs.get(0)));
        } else {
            plainSelect.setWhere((Expression)new AndExpression(where, CCJSqlParserUtil.parseCondExpression((String)sqlSegs.get(0))));
        }
        for (int i = 1; i < sqlSegs.size(); ++i) {
            plainSelect.setWhere((Expression)new AndExpression(where, CCJSqlParserUtil.parseCondExpression((String)sqlSegs.get(i))));
        }
        return sqlSegs;
    }

    protected List<String> createExpressions(Table table, DataScopeDefine scopeDefine) {
        ArrayList<String> sqlSegs = new ArrayList<String>();
        Map<String, ?> profiles = DataScopeContext.getDataScopes();
        if (profiles != null && !profiles.isEmpty()) {
            for (Map.Entry<String, ?> entry : profiles.entrySet()) {
                List vals;
                String key = entry.getKey();
                List list = vals = entry.getValue() == null ? null : (List)entry.getValue();
                DataScopeDefine.Definition dc = scopeDefine.getDefinition(key);
                if (dc == null || vals == null || vals.size() < 1) continue;
                boolean isDataScopeColumn = this.isDataScopeColumn(table, dc);
                if (isDataScopeColumn) {
                    String colName;
                    String string = colName = this.isEmpty(dc.getColumnAlias()) ? "`" + dc.getColumn() + "`" : "`" + dc.getColumnAlias() + "`.`" + dc.getColumn() + "`";
                    if (vals.size() == 1) {
                        sqlSegs.add(colName + "=" + this.processValue((String)vals.get(0), dc));
                        continue;
                    }
                    sqlSegs.add(colName + " in " + this.processValues(vals, dc));
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Column [{}] not in sql[{}],will igornal data scope filter.", (Object)(dc.getColumnAlias() + "." + dc.getColumn()), (Object)table);
            }
        }
        return sqlSegs;
    }

    private boolean isEmpty(String str) {
        return str == null || str.trim().length() < 1;
    }

    protected boolean isDataScopeColumn(Table table, DataScopeDefine.Definition dc) {
        if (dc.getColumnAlias() == null || dc.getColumnAlias().length() < 1) {
            return true;
        }
        String tableAlias = table.getAlias() == null ? null : table.getAlias().getName();
        return dc.getColumnAlias().equals(tableAlias) || dc.getColumnAlias().equals(tableAlias.replaceAll("`", ""));
    }

    protected String processValue(String val, DataScopeDefine.Definition dc) {
        if (dc.getDataType() != null && dc.getDataType().isAssignableFrom(Number.class)) {
            return val;
        }
        return "'" + val + "'";
    }

    protected String processValues(List<String> vals, DataScopeDefine.Definition dc) {
        StringBuilder sb = new StringBuilder("(");
        for (int i = 0; i < vals.size(); ++i) {
            String val = vals.get(i);
            sb.append(this.processValue(val, dc));
            if (i >= vals.size() - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }
}

