/*
 * Decompiled with CFR 0.152.
 */
package plus.ibatis.hbatis.plugins.pagination;

import java.util.List;
import java.util.function.Supplier;
import plus.ibatis.hbatis.plugins.pagination.PageExecutor;

public class Pager<T> {
    private long total;
    private List<T> data;
    private PagerParams params;

    public Pager(PagerParams pageParams) {
        this.params = pageParams;
    }

    public Pager(int start, int limit) {
        this.params = new DefaultPageParams(start, limit);
    }

    public void setStart(int start) {
        this.params = new DefaultPageParams(start, this.params.getLimit());
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public List<T> getData() {
        return this.data;
    }

    public void setData(List<T> data) {
        this.data = data;
    }

    public PagerParams getParams() {
        return this.params;
    }

    public Pager<T> data(Supplier<List<T>> pageLoadSupplier) {
        return PageExecutor.doPagination(this, pageLoadSupplier);
    }

    public Pager<T> data(Supplier<List<T>> pageLoadSupplier, boolean countFlag) {
        return PageExecutor.doPagination(this, pageLoadSupplier, countFlag);
    }

    public long count(Supplier<List<T>> pageLoadSupplier) {
        return PageExecutor.doCount(this, pageLoadSupplier);
    }

    static class DefaultPageParams
    implements PagerParams {
        private int start;
        private int limit;

        public DefaultPageParams(int start, int limit) {
            this.start = start;
            this.limit = limit;
        }

        @Override
        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        @Override
        public int getLimit() {
            return this.limit;
        }

        public void setLimit(int limit) {
            this.limit = limit;
        }
    }

    public static interface PagerParams {
        default public int getStart() {
            return 0;
        }

        default public int getLimit() {
            return 10;
        }
    }
}

