/*
 * Decompiled with CFR 0.152.
 */
package plus.ojbk.influxdb.core;

import java.time.LocalDateTime;
import java.util.Objects;
import java.util.TreeMap;
import org.springframework.util.ObjectUtils;
import plus.ojbk.influxdb.core.Op;
import plus.ojbk.influxdb.core.model.QueryModel;

public class Query
extends Op {
    public static String build(QueryModel model) {
        Objects.requireNonNull(model.getMeasurement(), "QueryModel.Measurement");
        StringBuilder query = new StringBuilder();
        query.append("select ").append(model.getSelect());
        query.append(" from ").append(model.getMeasurement());
        if (!ObjectUtils.isEmpty((Object)model.getWhere())) {
            query.append(" where ").append(model.getWhere());
        }
        if (!ObjectUtils.isEmpty((Object)model.getGroup())) {
            query.append(" group by ").append("\"").append(model.getGroup()).append("\"");
        }
        if (!ObjectUtils.isEmpty((Object)((Object)model.getOrder()))) {
            query.append(" order by time ").append((Object)model.getOrder());
        }
        if (!ObjectUtils.isEmpty((Object)model.getCurrent()) && !ObjectUtils.isEmpty((Object)model.getSize())) {
            query.append(" ").append(model.getPageQuery());
        }
        if (model.getUseTimeZone().booleanValue()) {
            query.append(" ").append(model.getTimeZone());
        }
        String sql = query.toString();
        log.info(sql);
        return sql;
    }

    public static String count(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("count(").append("\"").append(field).append("\"").append(")");
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        map.put("device_id", "666");
        map.put("temp", 5.1);
        QueryModel model = new QueryModel();
        model.setMap(map);
        model.setEnd(LocalDateTime.now());
        model.setMeasurement("ojbk");
        model.setUseTimeZone(true);
        model.setWhere(Op.where(model));
        System.err.println(Query.build(model));
    }
}

