/*
 * Decompiled with CFR 0.152.
 */
package plus.ojbk.influxdb.autoconfigure;

import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import plus.ojbk.influxdb.autoconfigure.properties.InfluxdbProperties;
import plus.ojbk.influxdb.core.InfluxdbTemplate;

@Configuration
@EnableConfigurationProperties(value={InfluxdbProperties.class})
@ConditionalOnProperty(prefix="influxdb", value={"enable"}, matchIfMissing=true)
public class InfluxdbAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public InfluxDB influxdb(InfluxdbProperties influxdbProperties) {
        InfluxDB influxDB = InfluxDBFactory.connect((String)influxdbProperties.getUrl(), (String)influxdbProperties.getUsername(), (String)influxdbProperties.getPassword());
        influxDB.setDatabase(influxdbProperties.getDatabase());
        influxDB.setLogLevel(InfluxDB.LogLevel.BASIC);
        return influxDB;
    }

    @Bean
    public InfluxdbTemplate influxdbTemplate(InfluxdbProperties influxdbProperties) {
        return new InfluxdbTemplate(influxdbProperties);
    }
}

