/*
 * Decompiled with CFR 0.152.
 */
package plus.ojbk.influxdb.util;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.influxdb.annotation.Column;
import org.influxdb.annotation.Measurement;
import org.influxdb.dto.Point;
import org.influxdb.dto.QueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;
import plus.ojbk.influxdb.annotation.Aggregate;
import plus.ojbk.influxdb.annotation.Count;
import plus.ojbk.influxdb.core.Query;
import plus.ojbk.influxdb.util.CommonUtils;

public class InfluxdbUtils {
    private static Logger log = LoggerFactory.getLogger(InfluxdbUtils.class);

    public static <T> List<T> toPOJO(QueryResult queryResult, Class<T> clazz) {
        Objects.requireNonNull(queryResult, "queryResult");
        Objects.requireNonNull(clazz, "clazz");
        LinkedList<Object> results = new LinkedList<Object>();
        for (QueryResult.Result result : queryResult.getResults()) {
            if (result.getSeries() != null) {
                for (QueryResult.Series series : result.getSeries()) {
                    List columns = series.getColumns();
                    int fieldSize = columns.size();
                    for (List value : series.getValues()) {
                        Object obj;
                        block12: {
                            obj = null;
                            try {
                                Field field;
                                obj = clazz.newInstance();
                                for (int i = 0; i < fieldSize; ++i) {
                                    String fieldName = (String)columns.get(i);
                                    field = null;
                                    try {
                                        field = clazz.getDeclaredField(CommonUtils.lineToHump(fieldName));
                                        field.setAccessible(true);
                                    }
                                    catch (NoSuchFieldException e) {
                                        log.error("Field :{} Not fount, error :{}", (Object)fieldName, (Object)e.getMessage());
                                    }
                                    if (field == null || value.get(i) == null) continue;
                                    Class<?> type = field.getType();
                                    InfluxdbUtils.setFieldValue(type, value, i, obj, field);
                                }
                                if (series.getTags() == null || series.getTags().isEmpty()) break block12;
                                for (Map.Entry entry : series.getTags().entrySet()) {
                                    field = null;
                                    try {
                                        field = clazz.getDeclaredField(CommonUtils.lineToHump((String)entry.getKey()));
                                        field.setAccessible(true);
                                    }
                                    catch (NoSuchFieldException e) {
                                        log.error("Field :{} Not fount, error :{}", entry.getKey(), (Object)e.getMessage());
                                    }
                                    if (field == null) continue;
                                    InfluxdbUtils.setFieldValue(obj, field, entry.getValue());
                                }
                            }
                            catch (IllegalAccessException | InstantiationException | SecurityException e) {
                                log.error("Influxdb toPOJO error :{}", (Object)e.getMessage());
                            }
                        }
                        results.add(obj);
                    }
                }
                continue;
            }
            log.info("QueryResult.Result Is Null.");
        }
        return results;
    }

    public static long count(QueryResult queryResult) {
        for (QueryResult.Result result : queryResult.getResults()) {
            if (result.getSeries() == null) continue;
            for (QueryResult.Series series : result.getSeries()) {
                List columns = series.getColumns();
                int index = columns.indexOf("count");
                if (index == -1) continue;
                BigDecimal count = new BigDecimal(((List)series.getValues().get(0)).get(index).toString());
                return count.longValue();
            }
        }
        return 0L;
    }

    public static Point save(Object object) {
        Field[] fields;
        Class<?> clazz = object.getClass();
        Measurement measurement = clazz.getAnnotation(Measurement.class);
        Point.Builder builder = Point.measurement((String)measurement.name());
        for (Field field : fields = clazz.getDeclaredFields()) {
            try {
                Column column = field.getAnnotation(Column.class);
                field.setAccessible(true);
                if (column.tag()) {
                    builder.tag(column.name(), field.get(object).toString());
                    continue;
                }
                if (field.get(object) == null) continue;
                if ("time".equals(column.name())) {
                    builder.time(Long.valueOf(CommonUtils.parseLocalDateTimeToInstant((LocalDateTime)field.get(object)).getEpochSecond()), TimeUnit.SECONDS);
                    continue;
                }
                builder.field(column.name(), field.get(object));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                log.error("Influxdb save error. error :{}", (Object)e.getMessage());
            }
        }
        return builder.build();
    }

    public static long delete(QueryResult queryResult) {
        for (QueryResult.Result result : queryResult.getResults()) {
            if (result.getError() == null) continue;
            throw new RuntimeException(result.getError());
        }
        return 1L;
    }

    public static boolean checkDatabase(QueryResult queryResult, String databaseName) {
        for (QueryResult.Result result : queryResult.getResults()) {
            if (result.getSeries() == null) continue;
            for (QueryResult.Series series : result.getSeries()) {
                for (List databases : series.getValues()) {
                    if (!databaseName.equals(databases.get(0))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static void setFieldValue(Class<?> type, List<Object> value, int i, Object obj, Field field) throws IllegalAccessException {
        if (type.equals(Long.class)) {
            BigDecimal v = new BigDecimal(value.get(i).toString());
            field.set(obj, v.longValue());
        } else if (type.equals(Integer.class)) {
            BigDecimal v = new BigDecimal(value.get(i).toString());
            field.set(obj, v.intValue());
        } else if (type.equals(Float.class)) {
            BigDecimal v = new BigDecimal(value.get(i).toString());
            field.set(obj, Float.valueOf(v.floatValue()));
        } else if (type.equals(Double.class)) {
            BigDecimal v = new BigDecimal(value.get(i).toString());
            field.set(obj, v.doubleValue());
        } else if (type.equals(BigDecimal.class)) {
            BigDecimal v = new BigDecimal(value.get(i).toString());
            field.set(obj, v);
        } else if (type.equals(LocalDateTime.class)) {
            field.set(obj, CommonUtils.parseStringToLocalDateTime(value.get(i).toString()));
        } else {
            field.set(obj, value.get(i));
        }
    }

    private static void setFieldValue(Object obj, Field field, Object value) throws IllegalAccessException {
        field.set(obj, value);
    }

    public static <T> String getMeasurement(Class<T> clazz) {
        Measurement measurement = clazz.getAnnotation(Measurement.class);
        return measurement.name();
    }

    public static <T> String getCountField(Class<T> clazz) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            Count count = field.getAnnotation(Count.class);
            if (ObjectUtils.isEmpty((Object)count)) continue;
            return count.value();
        }
        throw new RuntimeException("\u8bf7\u4f7f\u7528@Count\u6ce8\u89e3\u5230\u76f8\u5e94\u7684\u5b57\u6bb5\u4e0a");
    }

    public static <T> String getAggregateSelect(Class<T> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        StringBuilder temp = new StringBuilder();
        int i = 0;
        for (Field field : fields) {
            Aggregate aggregate = field.getAnnotation(Aggregate.class);
            if (ObjectUtils.isEmpty((Object)aggregate)) continue;
            if (i != 0) {
                temp.append(", ");
            }
            temp.append((CharSequence)Query.funcAggregate(aggregate.tag().getTag(), aggregate.value()));
            ++i;
        }
        return temp.toString();
    }
}

