/*
 * Decompiled with CFR 0.152.
 */
package plus.ojbk.minio.autoconfigure;

import io.minio.MinioClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import plus.ojbk.minio.autoconfigure.properties.MinioProperties;
import plus.ojbk.minio.core.MinioTemplate;

@Configuration
@EnableConfigurationProperties(value={MinioProperties.class})
@ConditionalOnProperty(prefix="file.minio", value={"enable"}, matchIfMissing=true)
public class MinioAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public MinioClient minioClient(MinioProperties minioProperties) {
        return MinioClient.builder().endpoint(minioProperties.getEndpoint()).credentials(minioProperties.getAccessKey(), minioProperties.getSecretKey()).build();
    }

    @Bean
    public MinioTemplate minioTemplate(MinioProperties minioProperties) {
        return new MinioTemplate(minioProperties);
    }
}

