/*
 * Decompiled with CFR 0.152.
 */
package plus.ojbk.minio.core;

import io.minio.BucketExistsArgs;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.ObjectWriteResponse;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.http.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.multipart.MultipartFile;
import plus.ojbk.minio.autoconfigure.properties.MinioProperties;
import plus.ojbk.minio.util.MinioUtils;

public class MinioTemplate {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private MinioProperties properties;
    private String endpoint;
    private String bucket;
    private String accessKey;
    private String secretKey;
    public static final String URI_DELIMITER = "/";
    @Autowired
    private MinioClient minioClient;
    private MinioClient expandClient;

    public MinioTemplate(MinioProperties properties) {
        this.properties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MinioClient getMinioClient() {
        if (this.expandClient != null) return this.expandClient;
        Class<MinioTemplate> clazz = MinioTemplate.class;
        synchronized (MinioTemplate.class) {
            if (this.expandClient != null) return this.expandClient;
            this.expandClient = this.minioClient;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.expandClient;
        }
    }

    @PostConstruct
    private void init() {
        this.endpoint = this.properties.getEndpoint();
        this.bucket = this.properties.getBucket();
        this.accessKey = this.properties.getAccessKey();
        this.secretKey = this.properties.getSecretKey();
    }

    @PostConstruct
    private void initDefaultBucket() throws Exception {
        if (this.minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(this.bucket)).build())) {
            this.log.info("Bucket :{} already exists.", (Object)this.bucket);
        } else {
            this.minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(this.bucket)).build());
        }
    }

    public String getObject(String object) {
        return this.getObject(object, 1, TimeUnit.HOURS);
    }

    public String getObject(String object, int duration, TimeUnit unit) {
        String url;
        try {
            url = this.minioClient.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).expiry(duration, unit).bucket(this.bucket)).object(object)).build());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return url;
    }

    public void deleteObject(String object) {
        try {
            this.minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(this.bucket)).object(object)).build());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ObjectWriteResponse putObject(MultipartFile multipartFile) {
        try {
            CharSequence[] folders = MinioUtils.getDateFolder();
            String fileName = MinioUtils.getUUID() + "." + MinioUtils.getSuffix(multipartFile.getOriginalFilename());
            String finalPath = String.join((CharSequence)URI_DELIMITER, folders) + URI_DELIMITER + fileName;
            ObjectWriteResponse response = this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().stream(multipartFile.getInputStream(), multipartFile.getSize(), 0x500000L).object(finalPath)).contentType(multipartFile.getContentType()).bucket(this.bucket)).build());
            return response;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<ObjectWriteResponse> putObject(MultipartFile ... multipartFiles) {
        try {
            ArrayList<ObjectWriteResponse> retVal = new ArrayList<ObjectWriteResponse>();
            CharSequence[] folders = MinioUtils.getDateFolder();
            for (MultipartFile multipartFile : multipartFiles) {
                String fileName = MinioUtils.getUUID() + "." + MinioUtils.getSuffix(multipartFile.getOriginalFilename());
                String finalPath = String.join((CharSequence)URI_DELIMITER, folders) + URI_DELIMITER + fileName;
                ObjectWriteResponse response = this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().stream(multipartFile.getInputStream(), multipartFile.getSize(), 0x500000L).object(finalPath)).contentType(multipartFile.getContentType()).bucket(this.bucket)).build());
                retVal.add(response);
            }
            return retVal;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

