/*
 * Decompiled with CFR 0.152.
 */
package plus.ojbk.minio.util;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.UUID;

public class MinioUtils {
    public static String getSuffix(String fileName) {
        String suffix;
        if (fileName == null) {
            throw new IllegalArgumentException("\u975e\u6cd5\u6587\u4ef6\u540d\u79f0");
        }
        int index = fileName.lastIndexOf(".");
        if (index != -1 && !(suffix = fileName.substring(index + 1)).isEmpty()) {
            return suffix;
        }
        throw new IllegalArgumentException("\u975e\u6cd5\u6587\u4ef6\u540d\u79f0\uff1a" + fileName);
    }

    public static String getFileName(String object) {
        if (object == null || "".equals(object)) {
            throw new IllegalArgumentException("\u975e\u6cd5\u6587\u4ef6\u540d\u79f0");
        }
        String[] a = object.split("/");
        return a[a.length - 1];
    }

    public static String[] getDateFolder() {
        return MinioUtils.getDateFolder(null);
    }

    public static String[] getDateFolder(String folder) {
        String[] retVal = new String[3];
        LocalDate localDate = LocalDate.now();
        retVal[0] = localDate.getYear() + "";
        int month = localDate.getMonthValue();
        retVal[1] = month < 10 ? "0" + month : month + "";
        int day = localDate.getDayOfMonth();
        retVal[2] = day < 10 ? "0" + day : day + "";
        String[] newRetVal = null;
        if (folder != null && !"".equals(folder)) {
            newRetVal = Arrays.copyOf(retVal, retVal.length + 1);
            System.arraycopy(newRetVal, 0, newRetVal, 1, newRetVal.length - 1);
            newRetVal[0] = folder;
        }
        return newRetVal == null ? retVal : newRetVal;
    }

    public static String getUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }
}

