/*
 * Copyright (C) 2014 Dmitry Kotlyarov, Dmitriy Rogozhin.
 * All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package apphub.service.api;

import apphub.util.CborUtil;
import apphub.util.JsonUtil;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * @author Dmitry Kotlyarov
 * @since 1.0
 */
public class UserKey implements Serializable {
    private static final long serialVersionUID = 1;

    public final String user;
    public final String id;
    public final Timestamp createTime;
    public final String key;

    @JsonCreator
    public UserKey(@JsonProperty("user") String user,
                   @JsonProperty("id") String id,
                   @JsonProperty("createTime") Timestamp createTime,
                   @JsonProperty("key") String key) {
        this.user = user;
        this.id = id;
        this.createTime = createTime;
        this.key = key;
    }

    public byte[] toBytes() {
        return CborUtil.toBytes(this);
    }

    @Override
    public String toString() {
        return JsonUtil.toString(this);
    }

    public static UserKey valueOf(byte[] data) {
        return CborUtil.fromBytes(data, UserKey.class);
    }

    public static UserKey valueOf(String content) {
        return JsonUtil.fromString(content, UserKey.class);
    }
}
