/*
 * Copyright (C) 2014 Dmitry Kotlyarov, Dmitriy Rogozhin.
 * All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package apphub.storage;

/**
 * @author Dmitry Kotlyarov
 * @since 1.0
 */
public enum StorageType {
    S3("s3"),
    GS("gs"),
    AS("as"),
    SW("sw");

    public final String protocol;

    StorageType(String protocol) {
        this.protocol = protocol;
    }

    public String toUrl(String bucket, String object) {
        return String.format("%s://%s/%s", protocol, bucket, object);
    }
}
