/*
 * Copyright (C) 2014 Dmitry Kotlyarov, Dmitriy Rogozhin.
 * All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package apphub.util;

import java.nio.charset.Charset;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;

/**
 * @author Dmitry Kotlyarov
 * @since 1.0
 */
public final class Util {
    public static final Charset CHARSET = Charset.forName("UTF-8");

    private Util() {
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static String randomUUID() {
        return UUID.randomUUID().toString();
    }

    public static <T> String formatClassName(Class<T> clazz) {
        return clazz.getName().replace('.', '/');
    }

    public static <K, V> V putIfAbsent(ConcurrentMap<K, V> map, K key, V value) {
        V v = map.putIfAbsent(key, value);
        if (v != null) {
            return v;
        } else {
            return value;
        }
    }
}
