/*
 * Decompiled with CFR 0.152.
 */
package apphub;

import apphub.Config;
import apphub.EnvironmentType;
import apphub.Instance;
import apphub.storage.Storage;
import apphub.storage.StorageFactory;
import apphub.storage.aws.AWSStorageFactory;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;

public final class Environment {
    public static final StorageFactory STORAGE_FACTORY = Environment.createStorageFactory();
    private static final AtomicReference<Environment> environment = new AtomicReference<Object>(null);
    private static final ThreadLocal<Environment> threadEnvironment = new ThreadLocal();
    private final Instance instance = null;
    private final Instance[] instances = new Instance[1];
    private final HashMap<String, Instance> instancesMap = new HashMap();
    private final Storage storage = Environment.createStorage(Config.get().getEnvironment(), "");

    public static Environment get() {
        Environment environment = threadEnvironment.get();
        return environment != null ? environment : Environment.environment.get();
    }

    public static Environment acquire() {
        Environment environment = Environment.environment.get();
        threadEnvironment.set(environment);
        return environment;
    }

    public static Environment release() {
        Environment environment = threadEnvironment.get();
        threadEnvironment.remove();
        return environment;
    }

    public static Storage createStorage(String bucket, String prefix) {
        return STORAGE_FACTORY.create(bucket, prefix);
    }

    private static StorageFactory createStorageFactory() {
        EnvironmentType type = Config.get().getEnvironmentType();
        if (type.equals((Object)EnvironmentType.AWS)) {
            return new AWSStorageFactory();
        }
        if (type.equals((Object)EnvironmentType.GCP)) {
            return new AWSStorageFactory();
        }
        if (type.equals((Object)EnvironmentType.AZURE)) {
            return new AWSStorageFactory();
        }
        if (type.equals((Object)EnvironmentType.OS)) {
            return new AWSStorageFactory();
        }
        throw new RuntimeException(String.format("Illegal environment type '%s'", new Object[]{type}));
    }
}

