/*
 * Decompiled with CFR 0.152.
 */
package apphub.log;

import apphub.util.CborUtil;
import apphub.util.JsonUtil;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Map;

public final class Event
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final long time;
    public final Map<String, String> tags;
    public final String message;

    public Event(Map<String, String> tags, String message) {
        this.time = System.currentTimeMillis();
        this.tags = tags;
        this.message = message;
    }

    @JsonCreator
    public Event(@JsonProperty(value="time") long time, @JsonProperty(value="tags") Map<String, String> tags, @JsonProperty(value="message") String message) {
        this.time = time;
        this.tags = tags;
        this.message = message;
    }

    public byte[] toBytes() {
        return CborUtil.toBytes(this);
    }

    public String toString() {
        return JsonUtil.toString(this);
    }

    public static Event valueOf(byte[] data) {
        return CborUtil.fromBytes(data, Event.class);
    }

    public static Event valueOf(String content) {
        return JsonUtil.fromString(content, Event.class);
    }
}

