/*
 * Decompiled with CFR 0.152.
 */
package apphub.util;

import apphub.util.NotFoundException;
import java.util.Properties;

public final class PropertyUtil {
    private PropertyUtil() {
    }

    public static String getSystemProperty(String key) {
        String property = System.getProperty(key);
        if (property != null) {
            return property;
        }
        throw new NotFoundException(String.format("System property '%s' is not found", key));
    }

    public static String getProperty(Properties properties, String key) {
        String property = properties.getProperty(key);
        if (property != null) {
            return property;
        }
        throw new NotFoundException(String.format("Property '%s' is not found", key));
    }

    public static Properties toProperties(String[][] properties) {
        Properties props = new Properties();
        for (String[] property : properties) {
            props.setProperty(property[0], property[1]);
        }
        return props;
    }
}

