/*
 * Decompiled with CFR 0.152.
 */
package apphub.util;

import java.nio.ByteBuffer;

public final class StringUtil {
    private StringUtil() {
    }

    public static byte[] toBytes(String value) {
        int offset = 0;
        int length = value.length();
        ByteBuffer buffer = ByteBuffer.allocate(length * 2);
        for (int i = 0; i < length; ++i) {
            buffer.putChar(offset, value.charAt(i));
            offset += 2;
        }
        return buffer.array();
    }

    public static String fromBytes(byte[] data) {
        int offset = 0;
        int length = data.length / 2;
        char[] value = new char[length];
        ByteBuffer buffer = ByteBuffer.wrap(data);
        for (int i = 0; i < length; ++i) {
            value[i] = buffer.getChar(offset);
            offset += 2;
        }
        return new String(value);
    }

    public static String cut(String value, int length) {
        if (value != null) {
            if (value.length() <= length) {
                return value;
            }
            return value.substring(0, length);
        }
        return null;
    }
}

