/*
 * Decompiled with CFR 0.152.
 */
package apphub.util;

import java.nio.charset.Charset;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;

public final class Util {
    public static final Charset CHARSET = Charset.forName("UTF-8");

    private Util() {
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static String randomUUID() {
        return UUID.randomUUID().toString();
    }

    public static <T> String formatClassName(Class<T> clazz) {
        return clazz.getName().replace('.', '/');
    }

    public static <K, V> V putIfAbsent(ConcurrentMap<K, V> map, K key, V value) {
        V v = map.putIfAbsent(key, value);
        if (v != null) {
            return v;
        }
        return value;
    }
}

