/*
 * Decompiled with CFR 0.152.
 */
package pro.apphub.aws.cloudwatch.log4j2;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.logs.AWSLogsClient;
import com.amazonaws.services.logs.model.CreateLogStreamRequest;
import com.amazonaws.services.logs.model.DescribeLogGroupsRequest;
import com.amazonaws.services.logs.model.DescribeLogGroupsResult;
import com.amazonaws.services.logs.model.DescribeLogStreamsRequest;
import com.amazonaws.services.logs.model.DescribeLogStreamsResult;
import com.amazonaws.services.logs.model.InputLogEvent;
import com.amazonaws.services.logs.model.LogGroup;
import com.amazonaws.services.logs.model.LogStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import pro.apphub.aws.cloudwatch.log4j2.Buffer;
import pro.apphub.aws.cloudwatch.log4j2.FlushInfo;
import pro.apphub.aws.cloudwatch.log4j2.FlushWait;

@Plugin(name="CloudWatchAppender", category="Core", elementType="appender", printObject=true)
public final class CloudWatchAppender
extends AbstractAppender {
    public static final String INSTANCE = CloudWatchAppender.retrieveInstance();
    private final AtomicBoolean enabled = new AtomicBoolean(false);
    private final AtomicBoolean flag = new AtomicBoolean(true);
    private final AtomicLong lost = new AtomicLong(0L);
    private final String group;
    private final String stream;
    private final AWSLogsClient client;
    private final int capacity;
    private final Buffer buffer1;
    private final Buffer buffer2;
    private final int length;
    private final int span;
    private final FlushWait flushWait;
    private final Thread flushThread;
    private FlushInfo flushInfo;

    public CloudWatchAppender(String name, String group, String streamPrefix, String streamPostfix, String access, String secret, int capacity, int length, int span, Layout<? extends Serializable> layout) {
        super(name, null, (Layout)(layout != null ? layout : PatternLayout.createDefaultLayout()), false);
        if (group != null) {
            this.group = group;
            this.stream = CloudWatchAppender.initStream(streamPrefix, streamPostfix);
            this.client = CloudWatchAppender.initClient(access, secret);
            if (!CloudWatchAppender.checkGroup(group, this.client)) {
                throw new RuntimeException(String.format("Group '%s' is not found", group));
            }
            this.capacity = capacity;
            this.buffer1 = new Buffer(capacity);
            this.buffer2 = new Buffer(capacity);
            this.length = length;
            this.span = span;
            this.flushWait = new FlushWait(span);
            this.flushThread = new Thread(String.format("aws-cloudwatch-log4j2-flush-%s", name)){

                @Override
                public void run() {
                    while (CloudWatchAppender.this.enabled.get()) {
                        try {
                            CloudWatchAppender.this.flushWait.await(CloudWatchAppender.this.enabled, CloudWatchAppender.this.buffer1, CloudWatchAppender.this.buffer2);
                            CloudWatchAppender.this.flag.set(false);
                            CloudWatchAppender.this.flushInfo = CloudWatchAppender.this.buffer1.flush(CloudWatchAppender.this.client, CloudWatchAppender.this.group, CloudWatchAppender.this.stream, CloudWatchAppender.this.flushInfo, CloudWatchAppender.this.lost);
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                        try {
                            CloudWatchAppender.this.flushWait.await(CloudWatchAppender.this.enabled, CloudWatchAppender.this.buffer1, CloudWatchAppender.this.buffer2);
                            CloudWatchAppender.this.flag.set(true);
                            CloudWatchAppender.this.flushInfo = CloudWatchAppender.this.buffer2.flush(CloudWatchAppender.this.client, CloudWatchAppender.this.group, CloudWatchAppender.this.stream, CloudWatchAppender.this.flushInfo, CloudWatchAppender.this.lost);
                        }
                        catch (Throwable e) {}
                    }
                    try {
                        CloudWatchAppender.this.flag.set(false);
                        CloudWatchAppender.this.flushInfo = CloudWatchAppender.this.buffer1.flush(CloudWatchAppender.this.client, CloudWatchAppender.this.group, CloudWatchAppender.this.stream, CloudWatchAppender.this.flushInfo, CloudWatchAppender.this.lost);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    try {
                        CloudWatchAppender.this.flag.set(true);
                        CloudWatchAppender.this.flushInfo = CloudWatchAppender.this.buffer2.flush(CloudWatchAppender.this.client, CloudWatchAppender.this.group, CloudWatchAppender.this.stream, CloudWatchAppender.this.flushInfo, CloudWatchAppender.this.lost);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            };
            this.flushInfo = new FlushInfo(0L, CloudWatchAppender.checkStream(group, this.stream, this.client));
        } else {
            this.group = null;
            this.stream = null;
            this.client = null;
            this.capacity = 0;
            this.buffer1 = null;
            this.buffer2 = null;
            this.length = 0;
            this.span = 0;
            this.flushWait = null;
            this.flushThread = null;
            this.flushInfo = null;
        }
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public String getGroup() {
        return this.group;
    }

    public String getStream() {
        return this.stream;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getLength() {
        return this.length;
    }

    public int getSpan() {
        return this.span;
    }

    public void start() {
        super.start();
        if (this.group != null) {
            this.enabled.set(true);
            this.flushThread.setDaemon(false);
            this.flushThread.start();
        }
    }

    public void stop() {
        super.stop();
        if (this.group != null) {
            this.enabled.set(false);
            this.flushWait.signalAll();
            try {
                this.flushThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void append(LogEvent event) {
        if (this.enabled.get()) {
            InputLogEvent e = new InputLogEvent();
            e.setTimestamp(Long.valueOf(event.getTimeMillis()));
            String msg = new String(this.getLayout().toByteArray(event));
            if (msg.length() > this.length) {
                msg = msg.substring(0, this.length);
            }
            e.setMessage(msg);
            if (this.flag.get()) {
                if (!this.buffer1.append(e, this.flushWait) && !this.buffer2.append(e, this.flushWait)) {
                    this.lost.incrementAndGet();
                }
            } else if (!this.buffer2.append(e, this.flushWait) && !this.buffer1.append(e, this.flushWait)) {
                this.lost.incrementAndGet();
            }
        }
    }

    @PluginFactory
    public static CloudWatchAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="group") String group, @PluginAttribute(value="streamPrefix") String streamPrefix, @PluginAttribute(value="streamPostfix") String streamPostfix, @PluginAttribute(value="access") String access, @PluginAttribute(value="secret") String secret, @PluginAttribute(value="capacity") String capacity, @PluginAttribute(value="length") String length, @PluginAttribute(value="span") String span, @PluginElement(value="Layout") Layout<? extends Serializable> layout) {
        return new CloudWatchAppender(name != null ? name : "cloudwatch", CloudWatchAppender.getProperty("aws.cloudwatch.group", "AWS_CLOUDWATCH_GROUP", group, null), CloudWatchAppender.getProperty("aws.cloudwatch.stream.prefix", "AWS_CLOUDWATCH_STREAM_PREFIX", streamPrefix, null), CloudWatchAppender.getProperty("aws.cloudwatch.stream.postfix", "AWS_CLOUDWATCH_STREAM_POSTFIX", streamPostfix, null), CloudWatchAppender.getProperty("aws.cloudwatch.access", "AWS_CLOUDWATCH_ACCESS", access, null), CloudWatchAppender.getProperty("aws.cloudwatch.secret", "AWS_CLOUDWATCH_SECRET", secret, null), Integer.parseInt(CloudWatchAppender.getProperty("aws.cloudwatch.capacity", "AWS_CLOUDWATCH_CAPACITY", capacity, "10000")), Integer.parseInt(CloudWatchAppender.getProperty("aws.cloudwatch.length", "AWS_CLOUDWATCH_LENGTH", length, "4096")), Integer.parseInt(CloudWatchAppender.getProperty("aws.cloudwatch.span", "AWS_CLOUDWATCH_SPAN", span, "60")), layout);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String retrieveInstance() {
        try {
            URL url = new URL("http://169.254.169.254/latest/meta-data/instance-id");
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(10000);
            try (InputStream in = conn.getInputStream();){
                BufferedReader r = new BufferedReader(new InputStreamReader(in));
                String instance = r.readLine();
                if (instance != null) {
                    String string = instance;
                    return string;
                }
                throw new IOException("Instance is null");
            }
        }
        catch (IOException e) {
            try {
                return InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    private static String getProperty(String property, String variable, String value) {
        String v = CloudWatchAppender.getProperty(property, variable, value, null);
        if (v != null) {
            return v;
        }
        throw new RuntimeException(String.format("Property ['%s', '%s'] is not defined", property, variable));
    }

    private static String getProperty(String property, String variable, String value, String def) {
        String v = System.getProperty(property);
        if (v != null) {
            return v;
        }
        v = System.getenv(variable);
        if (v != null) {
            return v;
        }
        if (value != null) {
            return value;
        }
        return def;
    }

    private static String initStream(String prefix, String postfix) {
        String s = INSTANCE;
        if (prefix != null) {
            s = String.format("%s/%s", prefix, s);
        }
        if (postfix != null) {
            s = String.format("%s/%s", s, postfix);
        }
        return s;
    }

    private static AWSLogsClient initClient(String access, String secret) {
        if (access != null && secret != null) {
            return new AWSLogsClient((AWSCredentials)new BasicAWSCredentials(access, secret));
        }
        return new AWSLogsClient();
    }

    private static boolean checkGroup(String group, AWSLogsClient client) {
        List lgs;
        DescribeLogGroupsResult dlgr = client.describeLogGroups(new DescribeLogGroupsRequest().withLogGroupNamePrefix(group));
        if (dlgr != null && (lgs = dlgr.getLogGroups()) != null) {
            for (LogGroup lg : lgs) {
                if (!lg.getLogGroupName().equals(group)) continue;
                return true;
            }
        }
        return false;
    }

    private static String checkStream(String group, String stream, AWSLogsClient client) {
        List lss;
        DescribeLogStreamsResult dlsr = client.describeLogStreams(new DescribeLogStreamsRequest(group).withLogStreamNamePrefix(stream));
        if (dlsr != null && (lss = dlsr.getLogStreams()) != null) {
            for (LogStream ls : lss) {
                if (!ls.getLogStreamName().equals(stream)) continue;
                return ls.getUploadSequenceToken();
            }
        }
        client.createLogStream(new CreateLogStreamRequest(group, stream));
        return null;
    }
}

