/*
 * Decompiled with CFR 0.152.
 */
package pro.avodonosov.mvnhashver;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.SerializingDependencyNodeVisitor;

@Mojo(name="hashver", aggregator=true)
public class HashVerMojo
extends AbstractMojo {
    public static final String DIGEST_ALGO = "SHA-1";
    @Parameter(defaultValue="false", property="includeGroupId")
    boolean includeGroupId;
    @Parameter(property="extraHashData")
    String extraHashData;
    @Component(hint="default")
    private DependencyGraphBuilder dependencyGraphBuilder;
    @Inject
    MavenSession mavenSession;
    private static final Base64.Encoder BASE_64 = Base64.getEncoder().withoutPadding();

    public void execute() throws MojoExecutionException, MojoFailureException {
        HashMap<String, String> ownHashByArtifact = new HashMap<String, String>();
        for (Object prj : this.mavenSession.getProjects()) {
            try {
                ownHashByArtifact.put(ArtifactUtils.key((Artifact)prj.getArtifact()), this.ownHash((MavenProject)prj, this.extraHashData));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error calculating module own hash: " + prj.getName(), (Exception)e);
            }
        }
        HashMap<String, String> hashVers = new HashMap<String, String>();
        for (Object prj : this.mavenSession.getProjects()) {
            try {
                hashVers.put(this.hashVerKey((MavenProject)prj), HashVerMojo.fullHash((MavenProject)prj, this.mavenSession, this.dependencyGraphBuilder, ownHashByArtifact, this.extraHashData));
            }
            catch (DependencyGraphBuilderException e) {
                throw new MojoExecutionException("prjVersion() failed for " + prj.getName(), (Exception)((Object)e));
            }
        }
        this.logInfo("HashVers computed: " + hashVers.size());
        ArrayList keys = new ArrayList(hashVers.keySet());
        Collections.sort(keys);
        for (String prjKey : keys) {
            this.logInfo(prjKey + "=" + (String)hashVers.get(prjKey));
        }
        try {
            this.storeHashVers(hashVers);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error saving hashVers", (Exception)e);
        }
    }

    private void logInfo(String msg) {
        this.getLog().info((CharSequence)msg);
    }

    private String hashVerKey(MavenProject prj) {
        return this.includeGroupId ? prj.getGroupId() + "." + prj.getArtifactId() + ".version" : prj.getArtifactId() + ".version";
    }

    private void storeHashVers(Map<String, String> hashVers) throws IOException {
        this.storeHashVerProps(hashVers, "target/hashversions.properties");
    }

    private static List<String> sortedKeys(Map<String, ?> hashVers) {
        ArrayList<String> keys = new ArrayList<String>(hashVers.keySet());
        keys.sort(String::compareTo);
        return keys;
    }

    private static void ensureParentDirExists(String file) {
        File parentDir = new File(file).getParentFile();
        if (parentDir != null) {
            parentDir.mkdirs();
        }
    }

    private static BufferedWriter openWriter(String file) throws IOException {
        HashVerMojo.ensureParentDirExists(file);
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
    }

    private void storeMvnEx(Map<String, String> hashVers, String file) throws IOException {
        try (BufferedWriter out = HashVerMojo.openWriter(file);){
            out.write("#!/bin/sh\n");
            out.write("mvn");
            for (String key : HashVerMojo.sortedKeys(hashVers)) {
                out.write(" ");
                out.write("-D");
                out.write(key);
                out.write("=");
                out.write(hashVers.get(key));
            }
            out.write(" \"$@\"");
        }
        this.logInfo("Saved hasVers to " + file);
    }

    private void storeMavenConfig(Map<String, String> hashVers, String file) throws IOException {
        ArrayList<String> keys = new ArrayList<String>(hashVers.keySet());
        keys.sort(String::compareTo);
        try (BufferedWriter out = HashVerMojo.openWriter(file);){
            for (String key : HashVerMojo.sortedKeys(hashVers)) {
                out.write("-D");
                out.write(key);
                out.write("=");
                out.write(hashVers.get(key));
                out.newLine();
            }
        }
        this.logInfo("Saved hasVers to " + file);
    }

    private void storeHashVerProps(Map<String, String> hashVers, String file) throws IOException {
        Properties props = new Properties(){

            @Override
            public synchronized Enumeration<Object> keys() {
                ArrayList<Object> keys = new ArrayList<Object>(super.keySet());
                keys.sort(Comparator.comparing(Object::toString));
                return Collections.enumeration(keys);
            }
        };
        props.putAll(hashVers);
        HashVerMojo.ensureParentDirExists(file);
        try (FileOutputStream out = new FileOutputStream(file);){
            props.store(out, null);
        }
        this.logInfo("Saved hasVers to " + file);
    }

    private String ownHash(MavenProject module, String extraHashData) throws IOException {
        File basedir = module.getBasedir();
        MessageDigest digest = HashVerMojo.newDigest(extraHashData);
        HashVerMojo.fileHash(new File(basedir, "pom.xml"), digest);
        File srcDir = new File(basedir, "src");
        if (srcDir.exists()) {
            this.directoryHash(srcDir, digest);
        }
        return HashVerMojo.str(digest);
    }

    private void directoryHash(File dir, MessageDigest digest) throws IOException {
        this.logInfo("hashing directory: " + dir.getPath());
        digest.update(dir.getName().getBytes(StandardCharsets.UTF_8));
        File[] children = dir.listFiles();
        if (children == null) {
            throw new IOException(dir.getPath() + " is not a directory");
        }
        Arrays.sort(children, Comparator.comparing(File::getName));
        for (File child : children) {
            if (child.isDirectory()) {
                this.directoryHash(child, digest);
                continue;
            }
            assert (child.isFile());
            HashVerMojo.fileHash(child, digest);
        }
    }

    private static void fileHash(File f, MessageDigest digest) throws IOException {
        digest.update(f.getName().getBytes(StandardCharsets.UTF_8));
        try (FileInputStream in = new FileInputStream(f);){
            int len;
            byte[] buf = new byte[10240];
            while ((len = ((InputStream)in).read(buf)) != -1) {
                if (System.getProperty("hashverDigestSkip") != null) continue;
                digest.update(buf, 0, len);
            }
        }
    }

    static String fullHash(MavenProject prj, MavenSession session, DependencyGraphBuilder dependencyGraphBuilder, Map<String, String> ownHashByArtifact, String extraHashData) throws DependencyGraphBuilderException {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(session.getProjectBuildingRequest());
        buildingRequest.setProject(prj);
        DependencyNode rootNode = dependencyGraphBuilder.buildDependencyGraph((ProjectBuildingRequest)buildingRequest, null, (Collection)session.getProjects());
        String ownHash = ownHashByArtifact.get(ArtifactUtils.key((Artifact)prj.getArtifact()));
        if (ownHash == null) {
            throw new RuntimeException("Can find own hash for module " + prj.getName());
        }
        return ownHash + "." + HashVerMojo.dependencyTreeHash(rootNode, ownHashByArtifact, extraHashData);
    }

    private static String hashVerNodeString(DependencyNode node, String ownHash) {
        StringBuilder result = new StringBuilder();
        Artifact artifact = node.getArtifact();
        if (artifact.getGroupId() != null) {
            result.append(artifact.getGroupId());
            result.append(":");
        }
        result.append(artifact.getArtifactId());
        result.append(":");
        result.append(artifact.getType());
        if (artifact.hasClassifier()) {
            result.append(":");
            result.append(artifact.getClassifier());
        }
        result.append(":");
        result.append(ownHash);
        if (artifact.getScope() != null) {
            result.append(":");
            result.append(artifact.getScope());
        }
        if (node.getOptional() != null && node.getOptional().booleanValue()) {
            result.append(" (optional) ");
        }
        return result.toString();
    }

    private static String dependencyTreeHash(DependencyNode theRootNode, Map<String, String> ownHashByArtifact, String extraHashData) {
        StringWriter writer = new StringWriter();
        MySerializingDependencyNodeVisitor visitor = new MySerializingDependencyNodeVisitor(writer, ownHashByArtifact);
        theRootNode.accept((DependencyNodeVisitor)visitor);
        String tree = writer.toString();
        MessageDigest digest = HashVerMojo.newDigest(extraHashData);
        digest.update(tree.getBytes(StandardCharsets.UTF_8));
        return HashVerMojo.str(digest);
    }

    private static String str(MessageDigest digest) {
        return BASE_64.encodeToString(digest.digest()).replaceAll("\\+", "-").replaceAll("/", "_");
    }

    private static MessageDigest newDigest(String extraHashData) {
        try {
            MessageDigest digest = MessageDigest.getInstance(DIGEST_ALGO);
            if (extraHashData != null) {
                digest.update(extraHashData.getBytes(StandardCharsets.UTF_8));
            }
            return digest;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unexpected: SHA-1 is not supported by Java", e);
        }
    }

    static class MySerializingDependencyNodeVisitor
    extends SerializingDependencyNodeVisitor {
        Map<String, String> ownHashByArtifact;

        public MySerializingDependencyNodeVisitor(Writer writer, Map<String, String> ownHashByArtifact) {
            super(writer, SerializingDependencyNodeVisitor.STANDARD_TOKENS);
            this.ownHashByArtifact = ownHashByArtifact;
        }

        public boolean visit(final DependencyNode node) {
            return super.visit(new DependencyNode(){

                public Artifact getArtifact() {
                    return node.getArtifact();
                }

                public List<DependencyNode> getChildren() {
                    return node.getChildren();
                }

                public boolean accept(DependencyNodeVisitor visitor) {
                    return node.accept(visitor);
                }

                public DependencyNode getParent() {
                    return node.getParent();
                }

                public String getPremanagedVersion() {
                    return node.getPremanagedVersion();
                }

                public String getPremanagedScope() {
                    return node.getPremanagedScope();
                }

                public String getVersionConstraint() {
                    return node.getVersionConstraint();
                }

                public String toNodeString() {
                    String ownHash = ownHashByArtifact.get(ArtifactUtils.key((Artifact)node.getArtifact()));
                    if (ownHash != null) {
                        return HashVerMojo.hashVerNodeString(node, ownHash);
                    }
                    return node.toNodeString();
                }

                public Boolean getOptional() {
                    return node.getOptional();
                }
            });
        }
    }
}

