/*
 * Decompiled with CFR 0.152.
 */
package pro.avodonosov.mvnhashver;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.Arrays;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.repository.LocalArtifactRequest;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

@Singleton
@Named
@Component(role=AbstractMavenLifecycleParticipant.class, hint="hashver-extension")
public class MavenLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    @Requirement
    @Inject
    private Logger logger;
    @Inject
    ArtifactResolver artifactResolver;

    public void afterSessionStart(MavenSession session) throws MavenExecutionException {
        super.afterSessionStart(session);
        String baseDir = session.getExecutionRootDirectory();
        this.propFileToSysIfExists(session, baseDir + "/versions.properties");
        this.propFileToSysIfExists(session, baseDir + "/target/hashversions.properties");
    }

    private void propFileToSysIfExists(MavenSession session, String file) throws MavenExecutionException {
        File f = new File(file);
        if (!f.exists()) {
            this.logger.info("File is absent - loading nothing: " + file);
        } else {
            Properties props = new Properties();
            try {
                FileInputStream in = new FileInputStream(f);
                Object object = null;
                try {
                    props.load(in);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (in != null) {
                        if (object != null) {
                            try {
                                ((InputStream)in).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ((InputStream)in).close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new MavenExecutionException("Error loading " + file, (Throwable)e);
            }
            this.logInfo("Setting system properties from " + file);
            Properties sessionSysProps = session.getSystemProperties();
            for (Object e : props.keySet()) {
                this.logInfo(e.toString() + "=" + props.get(e));
                String key = e.toString();
                String val = props.get(e).toString();
                System.setProperty(key, val);
                sessionSysProps.put(key, val);
            }
        }
    }

    public void afterProjectsRead(MavenSession session) {
        if (!ConfigProps.skipExistingArtifacts.isTrue(session)) {
            return;
        }
        this.logInfo("Preparing to remove from the maven session the modules whose artifacts exist.");
        ExistenceCheckMethod[] existenceChecks = ExistenceCheckMethod.parse(ConfigProps.existenceCheckMethod.get(session));
        session.setProjects(session.getProjects().stream().filter(prj -> "pom".equals(prj.getPackaging()) || !this.artifactExists(existenceChecks, session, (MavenProject)prj)).collect(Collectors.toList()));
    }

    private void logInfo(String s) {
        this.logger.info("[HASHVER] " + s);
    }

    private void logInfo(String s, Throwable t) {
        this.logger.info("[HASHVER] " + s, t);
    }

    private static String getProp(MavenSession session, String name, String defaultValue) {
        String val = System.getProperty(name);
        if (val != null) {
            return val;
        }
        Properties projectProps = session.getTopLevelProject().getProperties();
        return projectProps.getProperty(name, defaultValue);
    }

    ExistenceCheck implementation(ExistenceCheckMethod method) {
        switch (method) {
            case resolve: {
                return this::canResolveArtifact;
            }
            case local: {
                return this::localArtifactExists;
            }
            case httpHead: {
                return this::canHttpHeadArtifact;
            }
        }
        throw new RuntimeException("Unexpected artifact existence check method: " + (Object)((Object)method));
    }

    boolean artifactExists(ExistenceCheckMethod[] methods, MavenSession session, MavenProject prj) {
        for (ExistenceCheckMethod method : methods) {
            if (!this.implementation(method).artifactExists(session, prj)) continue;
            return true;
        }
        return false;
    }

    private static DefaultArtifact aetherArtifact(org.apache.maven.artifact.Artifact a) {
        return new DefaultArtifact(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getType(), a.getVersion());
    }

    boolean canResolveArtifact(MavenSession session, MavenProject prj) {
        this.logInfo("resolve-checking existence of " + prj.getArtifact());
        ArtifactRequest req = new ArtifactRequest((Artifact)MavenLifecycleParticipant.aetherArtifact(prj.getArtifact()), prj.getRemoteProjectRepositories(), null);
        try {
            ArtifactResult result = this.artifactResolver.resolveArtifact(session.getRepositorySession(), req);
            this.logInfo("Resolution result '" + result.isResolved() + "' for " + prj.getArtifact());
            return result.isResolved();
        }
        catch (ArtifactResolutionException e) {
            this.logInfo("Failed to resolve artifact " + req);
            return false;
        }
    }

    boolean localArtifactExists(MavenSession session, MavenProject prj) {
        RepositorySystemSession repoSession = session.getRepositorySession();
        LocalRepositoryManager lrm = repoSession.getLocalRepositoryManager();
        LocalArtifactResult result = lrm.find(repoSession, new LocalArtifactRequest((Artifact)MavenLifecycleParticipant.aetherArtifact(prj.getArtifact()), null, null));
        this.logInfo("localArtifactExists: " + result.isAvailable() + " for " + prj.getArtifact());
        return result.isAvailable();
    }

    static String subUrl(String baseUrl, String subPath) {
        if (baseUrl.endsWith("/")) {
            if (subPath.startsWith("/")) {
                return baseUrl + subPath.substring(1);
            }
            return baseUrl + subPath;
        }
        if (subPath.startsWith("/")) {
            return baseUrl + subPath;
        }
        return baseUrl + "/" + subPath;
    }

    boolean canHttpHeadArtifact(MavenSession session, MavenProject prj) {
        this.logInfo("http-head-checking existence of " + prj.getArtifact());
        for (RemoteRepository repo : prj.getRemoteProjectRepositories()) {
            DefaultRepositoryLayout layout = new DefaultRepositoryLayout();
            URI artifactUri = URI.create(MavenLifecycleParticipant.subUrl(repo.getUrl(), layout.pathOf(prj.getArtifact())));
            try {
                HttpURLConnection connection = (HttpURLConnection)artifactUri.toURL().openConnection();
                connection.setRequestMethod("HEAD");
                connection.connect();
                boolean exists = connection.getResponseCode() == 200;
                this.logInfo("HTTP HEAD " + (exists ? "successful" : "failed") + " (" + connection.getResponseCode() + ") for " + artifactUri);
                if (!exists) continue;
                return true;
            }
            catch (IOException e) {
                this.logInfo("Failed to perform HTTP HEAD for " + artifactUri + " : " + e.getMessage());
            }
        }
        return false;
    }

    static enum ConfigProps {
        skipExistingArtifacts("false"),
        existenceCheckMethod("resolve");

        public final String defaultValue;

        private ConfigProps(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public boolean isTrue(MavenSession session) {
            String val = this.get(session);
            if (val == null) {
                return false;
            }
            if (val.isEmpty()) {
                return true;
            }
            return Boolean.parseBoolean(val);
        }

        public String get(MavenSession session) {
            return MavenLifecycleParticipant.getProp(session, this.name(), this.defaultValue);
        }
    }

    static enum ExistenceCheckMethod {
        resolve,
        local,
        httpHead;


        public static ExistenceCheckMethod[] parse(String methods) {
            String[] names = methods.split(",");
            return (ExistenceCheckMethod[])Arrays.stream(names).map(ExistenceCheckMethod::valueOf).toArray(ExistenceCheckMethod[]::new);
        }
    }

    static interface ExistenceCheck {
        public boolean artifactExists(MavenSession var1, MavenProject var2);
    }
}

