/*
 * Decompiled with CFR 0.152.
 */
package pro.avodonosov.mvnhashver;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import pro.avodonosov.mvnhashver.HashVerMojo;
import pro.avodonosov.mvnhashver.Utils;

@Mojo(name="projects-to-build", aggregator=true)
public class ProjectsToBuildMojo
extends HashVerMojo {
    @Parameter(property="dbDir", required=true)
    String dbDirPath;
    private static final byte[] DB_FILE_CONTENT = "1".getBytes(StandardCharsets.UTF_8);

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        File dbDir = new File(this.dbDirPath);
        if (!dbDir.isDirectory()) {
            throw new MojoExecutionException("Directory does not exist: " + dbDir.getAbsolutePath());
        }
        File targetDir = new File("target");
        File dbAdditionsDir = new File(targetDir, "hashver-db-additions");
        ProjectsToBuildMojo.ensureDirExists(dbAdditionsDir);
        try {
            Utils.cleanDir(dbAdditionsDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error cleaning " + dbAdditionsDir, (Exception)e);
        }
        Map<String, String> hashVers = super.executeImpl(this.mavenSession, this.includeGroupId, this.extraHashData);
        ArrayList<String> projects = new ArrayList<String>();
        for (MavenProject prj : this.mavenSession.getProjects()) {
            String hashVer;
            if (ProjectsToBuildMojo.dbContains(dbDir, prj, hashVer = hashVers.get(this.hashVerKey(prj, this.includeGroupId)))) continue;
            projects.add(":" + prj.getArtifactId());
            ProjectsToBuildMojo.saveDbAddition(dbAdditionsDir, prj, hashVer);
        }
        String projectsCsv = String.join((CharSequence)",", projects);
        this.logInfo("hashver-projects-to-build: " + projectsCsv);
        File affectedProjectsFile = new File(targetDir, "hashver-projects-to-build");
        this.logInfo("saving to " + affectedProjectsFile.getAbsolutePath());
        try {
            Utils.saveToFile(affectedProjectsFile, projectsCsv);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error saving 'projects to build' file", (Exception)e);
        }
    }

    static void saveDbAddition(File dir, MavenProject prj, String hashVer) throws MojoExecutionException {
        File f = ProjectsToBuildMojo.prjDbFile(dir, prj, hashVer);
        File parent = f.getParentFile();
        ProjectsToBuildMojo.ensureDirExists(parent);
        try {
            Utils.saveToFile(f, DB_FILE_CONTENT);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error saving file: " + f.getAbsolutePath());
        }
    }

    static void ensureDirExists(File dir) throws MojoExecutionException {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new MojoExecutionException("Error creating directory: " + dir.getAbsolutePath());
        }
    }

    static boolean dbContains(File dir, MavenProject prj, String hashVer) {
        return ProjectsToBuildMojo.prjDbFile(dir, prj, hashVer).exists();
    }

    static File prjDbFile(File dbDir, MavenProject prj, String hashVer) {
        String artifact = prj.getArtifactId();
        int dotPos = hashVer.indexOf(46);
        if (dotPos < 0) {
            throw new IllegalArgumentException("hashver is expected to have dot inside: " + hashVer);
        }
        String verGroup = hashVer.substring(0, 1) + hashVer.substring(dotPos, dotPos + 2);
        File groupDir = new File(dbDir, artifact + "-" + verGroup);
        return new File(groupDir, hashVer);
    }
}

