/*
 * Decompiled with CFR 0.152.
 */
package pro.avodonosov.mvnhashver;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.SerializingDependencyNodeVisitor;
import pro.avodonosov.mvnhashver.Utils;

@Mojo(name="hashver", aggregator=true)
public class HashVerMojo
extends AbstractMojo {
    public static final String HASHVER_PROP_FILE = "target/hashversions.properties";
    public static final String HASHVER_JSON_FILE = "target/hashversions.json";
    public static final String DIGEST_ALGO = "SHA-1";
    @Parameter(defaultValue="false", property="includeGroupId")
    boolean includeGroupId;
    @Parameter(property="extraHashData")
    String extraHashData;
    @Component(hint="default")
    private DependencyGraphBuilder dependencyGraphBuilder;
    @Inject
    MavenSession mavenSession;
    private static final String PATH_SEPARATOR = "/";
    private static final Base64.Encoder BASE_64 = Base64.getEncoder().withoutPadding();

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.executeImpl(this.mavenSession, this.includeGroupId, this.extraHashData);
    }

    protected Map<String, String> executeImpl(MavenSession mavenSession, boolean includeGroupId, String extraHashData) throws MojoExecutionException, MojoFailureException {
        Map<String, String> hashVers = this.computeHashVers(mavenSession, includeGroupId, extraHashData);
        this.logInfo("HashVers computed: " + hashVers.size());
        ArrayList<String> keys = new ArrayList<String>(hashVers.keySet());
        Collections.sort(keys);
        for (String prjKey : keys) {
            this.logInfo(prjKey + "=" + hashVers.get(prjKey));
        }
        try {
            this.storeHashVers(hashVers);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error saving hashVers", (Exception)e);
        }
        return hashVers;
    }

    protected Map<String, String> computeHashVers(MavenSession mavenSession, boolean includeGroupId, String extraHashData) throws MojoExecutionException {
        HashMap<String, String> ownHashByArtifact = new HashMap<String, String>();
        for (MavenProject prj : mavenSession.getProjects()) {
            try {
                ownHashByArtifact.put(ArtifactUtils.key((Artifact)prj.getArtifact()), this.ownHash(prj, extraHashData));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error calculating module own hash: " + prj.getName(), (Exception)e);
            }
        }
        HashMap<String, String> hashVers = new HashMap<String, String>();
        for (MavenProject prj : mavenSession.getProjects()) {
            try {
                hashVers.put(this.hashVerKey(prj, includeGroupId), this.fullHash(prj, mavenSession, this.dependencyGraphBuilder, ownHashByArtifact, extraHashData));
            }
            catch (IOException | DependencyGraphBuilderException e) {
                throw new MojoExecutionException("prjVersion() failed for " + prj.getName(), (Exception)e);
            }
        }
        return hashVers;
    }

    protected void logInfo(String msg) {
        this.getLog().info((CharSequence)("[HASHVER] " + msg));
    }

    protected void logDebug(String msg) {
        this.getLog().debug((CharSequence)("[HASHVER] " + msg));
    }

    protected void logWarn(String msg) {
        this.getLog().warn((CharSequence)("[HASHVER] " + msg));
    }

    protected String hashVerKey(MavenProject prj, boolean includeGroupId) {
        return includeGroupId ? prj.getGroupId() + "." + prj.getArtifactId() + ".version" : prj.getArtifactId() + ".version";
    }

    private void storeHashVers(Map<String, String> hashVers) throws IOException {
        this.storeHashVerProps(hashVers, HASHVER_PROP_FILE);
        this.storeHashVerJson(hashVers, HASHVER_JSON_FILE);
    }

    private static List<String> sortedKeys(Map<String, ?> hashVers) {
        ArrayList<String> keys = new ArrayList<String>(hashVers.keySet());
        keys.sort(String::compareTo);
        return keys;
    }

    private static void ensureParentDirExists(String file) {
        File parentDir = new File(file).getParentFile();
        if (parentDir != null) {
            parentDir.mkdirs();
        }
    }

    private static BufferedWriter openWriter(String file) throws IOException {
        HashVerMojo.ensureParentDirExists(file);
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
    }

    private void storeMvnEx(Map<String, String> hashVers, String file) throws IOException {
        try (BufferedWriter out = HashVerMojo.openWriter(file);){
            out.write("#!/bin/sh\n");
            out.write("mvn");
            for (String key : HashVerMojo.sortedKeys(hashVers)) {
                out.write(" ");
                out.write("-D");
                out.write(key);
                out.write("=");
                out.write(hashVers.get(key));
            }
            out.write(" \"$@\"");
        }
        this.logInfo("Saved hasVers to " + file);
    }

    private void storeMavenConfig(Map<String, String> hashVers, String file) throws IOException {
        ArrayList<String> keys = new ArrayList<String>(hashVers.keySet());
        keys.sort(String::compareTo);
        try (BufferedWriter out = HashVerMojo.openWriter(file);){
            for (String key : HashVerMojo.sortedKeys(hashVers)) {
                out.write("-D");
                out.write(key);
                out.write("=");
                out.write(hashVers.get(key));
                out.newLine();
            }
        }
        this.logInfo("Saved hasVers to " + file);
    }

    private void storeHashVerProps(Map<String, String> hashVers, String file) throws IOException {
        Properties props = new Properties(){

            @Override
            public synchronized Enumeration<Object> keys() {
                ArrayList<Object> keys = new ArrayList<Object>(super.keySet());
                keys.sort(Comparator.comparing(Object::toString));
                return Collections.enumeration(keys);
            }
        };
        props.putAll(hashVers);
        HashVerMojo.ensureParentDirExists(file);
        try (FileOutputStream out = new FileOutputStream(file);){
            props.store(out, null);
        }
        this.logInfo("Saved hasVers to " + file);
    }

    static String hashVerJson(Map<String, String> hashVers) {
        StringBuilder result = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(hashVers.keySet());
        keys.sort(Comparator.naturalOrder());
        String maybeSeparatror = "";
        result.append("{");
        for (String key : keys) {
            result.append(maybeSeparatror).append('\"').append(StringEscapeUtils.escapeJson((String)key)).append("\": \"").append(StringEscapeUtils.escapeJson((String)hashVers.get(key))).append("\"");
            maybeSeparatror = ",\n ";
        }
        result.append("}\n");
        return result.toString();
    }

    private void storeHashVerJson(Map<String, String> hashVers, String file) throws IOException {
        HashVerMojo.ensureParentDirExists(file);
        Utils.saveToFile(new File(file), HashVerMojo.hashVerJson(hashVers));
        this.logInfo("Saved hasVers to " + file);
    }

    private String ownHash(MavenProject module, String extraHashData) throws IOException {
        File basedir = module.getBasedir();
        MessageDigest digest = HashVerMojo.newDigest(extraHashData);
        HashVerMojo.fileHash(new File(basedir, "pom.xml"), "", digest);
        File srcDir = new File(basedir, "src");
        if (srcDir.exists()) {
            this.directoryHash(srcDir, "", digest);
        }
        return HashVerMojo.str(digest);
    }

    private void directoryHash(File dir, String parentPath, MessageDigest digest) throws IOException {
        this.logDebug("hashing directory: " + dir.getPath());
        String myPath = parentPath + PATH_SEPARATOR + dir.getName();
        digest.update(myPath.getBytes(StandardCharsets.UTF_8));
        File[] children = dir.listFiles();
        if (children == null) {
            throw new IOException(dir.getPath() + " is not a directory");
        }
        Arrays.sort(children, Comparator.comparing(File::getName));
        for (File child : children) {
            if (child.isDirectory()) {
                this.directoryHash(child, myPath, digest);
                continue;
            }
            assert (child.isFile());
            HashVerMojo.fileHash(child, myPath, digest);
        }
    }

    private static void fileHash(File f, String parentPath, MessageDigest digest) throws IOException {
        String myPath = parentPath + PATH_SEPARATOR + f.getName();
        digest.update(myPath.getBytes(StandardCharsets.UTF_8));
        HashVerMojo.fileContentHash(f, digest);
    }

    private static void fileContentHash(File f, MessageDigest digest) throws IOException {
        try (FileInputStream in = new FileInputStream(f);){
            int len;
            byte[] buf = new byte[10240];
            while ((len = ((InputStream)in).read(buf)) != -1) {
                if (System.getProperty(ExtraProperties.hashverDigestSkip.name()) != null) continue;
                digest.update(buf, 0, len);
            }
        }
    }

    String fullHash(MavenProject prj, MavenSession session, DependencyGraphBuilder dependencyGraphBuilder, Map<String, String> ownHashByArtifact, String extraHashData) throws DependencyGraphBuilderException, IOException, MojoExecutionException {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(session.getProjectBuildingRequest());
        buildingRequest.setProject(prj);
        DependencyNode rootNode = dependencyGraphBuilder.buildDependencyGraph((ProjectBuildingRequest)buildingRequest, null, (Collection)session.getProjects());
        String ownHash = ownHashByArtifact.get(ArtifactUtils.key((Artifact)prj.getArtifact()));
        if (ownHash == null) {
            throw new RuntimeException("Can find own hash for module " + prj.getName());
        }
        MessageDigest depTreeDigest = HashVerMojo.newDigest(extraHashData);
        this.ancestorPomsHash(prj, depTreeDigest);
        HashVerMojo.dependencyTreeHash(rootNode, ownHashByArtifact, depTreeDigest);
        return ownHash + "." + HashVerMojo.str(depTreeDigest);
    }

    private static String hashVerNodeString(DependencyNode node, String ownHash) {
        StringBuilder result = new StringBuilder();
        Artifact artifact = node.getArtifact();
        if (artifact.getGroupId() != null) {
            result.append(artifact.getGroupId());
            result.append(":");
        }
        result.append(artifact.getArtifactId());
        result.append(":");
        result.append(artifact.getType());
        if (artifact.hasClassifier()) {
            result.append(":");
            result.append(artifact.getClassifier());
        }
        result.append(":");
        result.append(ownHash);
        if (artifact.getScope() != null) {
            result.append(":");
            result.append(artifact.getScope());
        }
        if (node.getOptional() != null && node.getOptional().booleanValue()) {
            result.append(" (optional) ");
        }
        return result.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void ancestorPomsHash(MavenProject prj, MessageDigest digest) throws IOException, MojoExecutionException {
        Artifact parentArtifact = prj.getParentArtifact();
        for (MavenProject parent = prj.getParent(); parent != null; parent = parent.getParent()) {
            File pomFile = parent.getFile();
            if (pomFile == null && parentArtifact != null) {
                pomFile = parentArtifact.getFile();
            }
            if (pomFile == null) {
                String msg = "Unexpected situation when hashing ancestor poms of " + prj + ": both parent.getFile() and parentArtifact.getFile() are absent. The parent: " + parent + ".";
                String parentKey = parent.getGroupId() + ":" + parent.getArtifactId();
                if (null == System.getProperty(ExtraProperties.hashverAncestorPomsIgnoreErrors.name()) && !HashVerMojo.csvListMember(parentKey, System.getProperty(ExtraProperties.hashverAncestorPomsForRelaxedHashing.name()))) throw new MojoExecutionException(msg + " Please report this situation to https://github.com/avodonosov/hashver-maven-plugin/issues. Meanwhile you can mute the error by adding " + parentKey + " to the comma separated list in the " + (Object)((Object)ExtraProperties.hashverAncestorPomsForRelaxedHashing) + " property or just ignore all parent pom hashing  errors by setting the " + (Object)((Object)ExtraProperties.hashverAncestorPomsIgnoreErrors) + " property.");
                String parentDataToHash = parent.getGroupId() + ":" + parent.getArtifactId() + ":" + parent.getVersion();
                this.logWarn(msg + " Using a relaxed hashing - hash the following instead of the pom file: " + parentDataToHash);
                digest.update(parentDataToHash.getBytes(StandardCharsets.UTF_8));
            } else {
                HashVerMojo.fileContentHash(pomFile, digest);
            }
            parentArtifact = parent.getParentArtifact();
        }
    }

    static boolean csvListMember(String elem, String csvList) {
        if (csvList == null) {
            return false;
        }
        for (String part : csvList.split(",")) {
            if (!elem.equals(part)) continue;
            return true;
        }
        return false;
    }

    private static void dependencyTreeHash(DependencyNode theRootNode, Map<String, String> ownHashByArtifact, MessageDigest digest) {
        StringWriter writer = new StringWriter();
        MySerializingDependencyNodeVisitor visitor = new MySerializingDependencyNodeVisitor(writer, ownHashByArtifact);
        theRootNode.accept((DependencyNodeVisitor)visitor);
        String tree = writer.toString();
        digest.update(tree.getBytes(StandardCharsets.UTF_8));
    }

    private static String str(MessageDigest digest) {
        return BASE_64.encodeToString(digest.digest()).replaceAll("\\+", "-").replaceAll(PATH_SEPARATOR, "_");
    }

    private static MessageDigest newDigest(String extraHashData) {
        try {
            MessageDigest digest = MessageDigest.getInstance(DIGEST_ALGO);
            if (extraHashData != null) {
                digest.update(extraHashData.getBytes(StandardCharsets.UTF_8));
            }
            return digest;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unexpected: SHA-1 is not supported by Java", e);
        }
    }

    static class MySerializingDependencyNodeVisitor
    extends SerializingDependencyNodeVisitor {
        Map<String, String> ownHashByArtifact;

        public MySerializingDependencyNodeVisitor(Writer writer, Map<String, String> ownHashByArtifact) {
            super(writer, SerializingDependencyNodeVisitor.STANDARD_TOKENS);
            this.ownHashByArtifact = ownHashByArtifact;
        }

        public boolean visit(final DependencyNode node) {
            return super.visit(new DependencyNode(){

                public Artifact getArtifact() {
                    return node.getArtifact();
                }

                public List<DependencyNode> getChildren() {
                    return node.getChildren();
                }

                public boolean accept(DependencyNodeVisitor visitor) {
                    return node.accept(visitor);
                }

                public DependencyNode getParent() {
                    return node.getParent();
                }

                public String getPremanagedVersion() {
                    return node.getPremanagedVersion();
                }

                public String getPremanagedScope() {
                    return node.getPremanagedScope();
                }

                public String getVersionConstraint() {
                    return node.getVersionConstraint();
                }

                public String toNodeString() {
                    String ownHash = ownHashByArtifact.get(ArtifactUtils.key((Artifact)node.getArtifact()));
                    if (ownHash != null) {
                        return HashVerMojo.hashVerNodeString(node, ownHash);
                    }
                    if (node.getArtifact().isSnapshot()) {
                        String ignore = "ignore";
                        if (!"ignore".equals(System.getProperty(ExtraProperties.hashVerSnapshotDependencyMode.name()))) {
                            String errMsg = "You have a -SNAPSHOT dependency in the dependency tree, which is not very consistent with the idea of immutable hash versions: " + node.getArtifact() + ". Specify -D" + ExtraProperties.hashVerSnapshotDependencyMode.name() + "=" + "ignore" + " if you are sure. See also https://github.com/avodonosov/hashver-maven-plugin/issues/7";
                            throw new RuntimeException(errMsg);
                        }
                    }
                    return node.toNodeString();
                }

                public Boolean getOptional() {
                    return node.getOptional();
                }
            });
        }
    }

    static enum ExtraProperties {
        hashverDigestSkip,
        hashverAncestorPomsForRelaxedHashing,
        hashverAncestorPomsIgnoreErrors,
        hashVerSnapshotDependencyMode;

    }
}

