/*
 * Decompiled with CFR 0.152.
 */
package pro.avodonosov.mvnhashver;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.Arrays;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.repository.LocalArtifactRequest;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

@Singleton
@Named
@Component(role=AbstractMavenLifecycleParticipant.class, hint="hashver-extension")
public class MavenLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    @Requirement
    @Inject
    private Logger logger;
    @Inject
    ArtifactResolver artifactResolver;

    public void afterSessionStart(MavenSession session) throws MavenExecutionException {
        super.afterSessionStart(session);
        this.loadSysPropFiles(Config.sysPropFiles(), session);
    }

    private void loadSysPropFiles(String filesSpec, MavenSession session) throws MavenExecutionException {
        for (SysPropFile fileSpec : MavenLifecycleParticipant.parseSysPropFilesSpec(filesSpec)) {
            if (fileSpec.required) {
                this.propFileToSysRequired(session, fileSpec.file);
                continue;
            }
            this.propFileToSysOptional(session, fileSpec.file);
        }
    }

    static SysPropFile[] parseSysPropFilesSpec(String filesSpec) {
        if (null == filesSpec) {
            return new SysPropFile[0];
        }
        String[] parts = filesSpec.split(",");
        SysPropFile[] result = new SysPropFile[parts.length];
        int i = 0;
        for (String spec : parts) {
            SysPropFile elem = new SysPropFile();
            if (spec.startsWith("opt:")) {
                elem.required = false;
                elem.file = spec.substring("opt:".length());
            } else {
                elem.required = true;
                elem.file = spec;
            }
            result[i++] = elem;
        }
        return result;
    }

    private void propFileToSys(MavenSession session, File file) throws MavenExecutionException {
        Properties props = new Properties();
        try {
            FileInputStream in = new FileInputStream(file);
            Object object = null;
            try {
                props.load(in);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (in != null) {
                    if (object != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)in).close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MavenExecutionException("Error loading " + file, (Throwable)e);
        }
        this.logInfo("Setting system properties from " + file);
        Properties sessionSysProps = session.getSystemProperties();
        for (Object e : props.keySet()) {
            this.logInfo(e.toString() + "=" + props.get(e));
            String key = e.toString();
            String val = props.get(e).toString();
            System.setProperty(key, val);
            sessionSysProps.put(key, val);
        }
    }

    static File resolveFile(String file, MavenSession session) {
        File f = new File(file);
        if (f.isAbsolute()) {
            return f;
        }
        String baseDir = session.getExecutionRootDirectory();
        return new File(baseDir + File.separator + file);
    }

    private void propFileToSysOptional(MavenSession session, String file) throws MavenExecutionException {
        File f = MavenLifecycleParticipant.resolveFile(file, session);
        if (!f.exists()) {
            this.logInfo("File is absent - loading nothing: " + file);
        } else {
            this.propFileToSys(session, f);
        }
    }

    private void propFileToSysRequired(MavenSession session, String file) throws MavenExecutionException {
        File f = MavenLifecycleParticipant.resolveFile(file, session);
        if (!f.exists()) {
            throw new MavenExecutionException("File is absent: " + file, (Throwable)null);
        }
        this.propFileToSys(session, f);
    }

    public void afterProjectsRead(MavenSession session) {
        if (!Config.skipExistingArtifacts(session)) {
            return;
        }
        this.logInfo("Preparing to remove from the maven session the modules whose artifacts exist.");
        ExistenceCheckMethod[] existenceChecks = ExistenceCheckMethod.parse(Config.existenceCheckMethods(session));
        session.setProjects(session.getProjects().stream().filter(prj -> "pom".equals(prj.getPackaging()) || !this.artifactExists(existenceChecks, session, (MavenProject)prj)).collect(Collectors.toList()));
    }

    private void logInfo(String s) {
        this.logger.info("[HASHVER] " + s);
    }

    private void logInfo(String s, Throwable t) {
        this.logger.info("[HASHVER] " + s, t);
    }

    ExistenceCheck implementation(ExistenceCheckMethod method) {
        switch (method) {
            case resolve: {
                return this::canResolveArtifact;
            }
            case local: {
                return this::localArtifactExists;
            }
            case httpHead: {
                return this::canHttpHeadArtifact;
            }
        }
        throw new RuntimeException("Unexpected artifact existence check method: " + (Object)((Object)method));
    }

    boolean artifactExists(ExistenceCheckMethod[] methods, MavenSession session, MavenProject prj) {
        for (ExistenceCheckMethod method : methods) {
            if (!this.implementation(method).artifactExists(session, prj)) continue;
            return true;
        }
        return false;
    }

    private static DefaultArtifact aetherArtifact(org.apache.maven.artifact.Artifact a) {
        return new DefaultArtifact(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getType(), a.getVersion());
    }

    boolean canResolveArtifact(MavenSession session, MavenProject prj) {
        this.logInfo("resolve-checking existence of " + prj.getArtifact());
        ArtifactRequest req = new ArtifactRequest((Artifact)MavenLifecycleParticipant.aetherArtifact(prj.getArtifact()), prj.getRemoteProjectRepositories(), null);
        try {
            ArtifactResult result = this.artifactResolver.resolveArtifact(session.getRepositorySession(), req);
            this.logInfo("Resolution result '" + result.isResolved() + "' for " + prj.getArtifact());
            return result.isResolved();
        }
        catch (ArtifactResolutionException e) {
            this.logInfo("Failed to resolve artifact " + req);
            return false;
        }
    }

    boolean localArtifactExists(MavenSession session, MavenProject prj) {
        RepositorySystemSession repoSession = session.getRepositorySession();
        LocalRepositoryManager lrm = repoSession.getLocalRepositoryManager();
        LocalArtifactResult result = lrm.find(repoSession, new LocalArtifactRequest((Artifact)MavenLifecycleParticipant.aetherArtifact(prj.getArtifact()), null, null));
        this.logInfo("localArtifactExists: " + result.isAvailable() + " for " + prj.getArtifact());
        return result.isAvailable();
    }

    static String subUrl(String baseUrl, String subPath) {
        if (baseUrl.endsWith("/")) {
            if (subPath.startsWith("/")) {
                return baseUrl + subPath.substring(1);
            }
            return baseUrl + subPath;
        }
        if (subPath.startsWith("/")) {
            return baseUrl + subPath;
        }
        return baseUrl + "/" + subPath;
    }

    boolean canHttpHeadArtifact(MavenSession session, MavenProject prj) {
        this.logInfo("http-head-checking existence of " + prj.getArtifact());
        for (RemoteRepository repo : prj.getRemoteProjectRepositories()) {
            DefaultRepositoryLayout layout = new DefaultRepositoryLayout();
            URI artifactUri = URI.create(MavenLifecycleParticipant.subUrl(repo.getUrl(), layout.pathOf(prj.getArtifact())));
            try {
                HttpURLConnection connection = (HttpURLConnection)artifactUri.toURL().openConnection();
                connection.setRequestMethod("HEAD");
                connection.connect();
                boolean exists = connection.getResponseCode() == 200;
                this.logInfo("HTTP HEAD " + (exists ? "successful" : "failed") + " (" + connection.getResponseCode() + ") for " + artifactUri);
                if (!exists) continue;
                return true;
            }
            catch (IOException e) {
                this.logInfo("Failed to perform HTTP HEAD for " + artifactUri + " : " + e.getMessage());
            }
        }
        return false;
    }

    static enum ConfigProps {
        hashverMode("false"),
        sysPropFiles("versions.properties"),
        skipExistingArtifacts("false"),
        existenceCheckMethods("resolve");

        public final String defaultValue;

        private ConfigProps(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public String get(MavenSession session) {
            return ConfigProps.getProp(session, this.name(), this.defaultValue);
        }

        public String getSys() {
            return System.getProperty(this.name(), this.defaultValue);
        }

        private static String getProp(MavenSession session, String name, String defaultValue) {
            String val = System.getProperty(name);
            if (val != null) {
                return val;
            }
            Properties prjProps = session.getTopLevelProject().getProperties();
            return prjProps.getProperty(name, defaultValue);
        }
    }

    static class Config {
        Config() {
        }

        public static String existenceCheckMethods(MavenSession session) {
            return ConfigProps.existenceCheckMethods.get(session);
        }

        public static boolean skipExistingArtifacts(MavenSession session) {
            return Config.isTrue(ConfigProps.hashverMode.getSys()) || Config.isTrue(ConfigProps.skipExistingArtifacts.get(session));
        }

        public static String sysPropFiles() {
            return Config.isTrue(ConfigProps.hashverMode.getSys()) ? "target/hashversions.properties" : ConfigProps.sysPropFiles.getSys();
        }

        public static boolean isTrue(String propVal) {
            if (propVal == null) {
                return false;
            }
            if (propVal.isEmpty()) {
                return true;
            }
            return Boolean.parseBoolean(propVal);
        }
    }

    static enum ExistenceCheckMethod {
        resolve,
        local,
        httpHead;


        public static ExistenceCheckMethod[] parse(String methods) {
            String[] names = methods.split(",");
            return (ExistenceCheckMethod[])Arrays.stream(names).map(ExistenceCheckMethod::valueOf).toArray(ExistenceCheckMethod[]::new);
        }
    }

    static interface ExistenceCheck {
        public boolean artifactExists(MavenSession var1, MavenProject var2);
    }

    static class SysPropFile {
        boolean required = true;
        String file;

        SysPropFile() {
        }
    }
}

